set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0100',
      NULL,
      NULL,
      '12024111',
      '23310241',
      NULL,
      '44100003',
      '24413032',
      '13422422',
      '01423434',
      '22020442',
      NULL,
      NULL,
      NULL,
      '41114431',
      '42131403',
      NULL,
      '22243240',
      '43223303',
      '42034103',
      '23422204',
      '43204304',
      '13303441',
      '33123441',
      NULL,
      '34424341',
      '42012400',
      '23323003',
      '33100020',
      NULL,
      '32141220',
      NULL,
      '34430104',
      '34024303',
      '00311124',
      '21344411',
      NULL,
      NULL,
      '02413440',
      NULL,
      '00441214',
      '14223242',
      '44442431',
      '03432134',
      NULL,
      '143',
      '34',
      5,
      10,
      '2141132',
      0.826370,
      65.428846,
      0,
      NULL,
      '121401',
      1,
      ' 3-24-1985',
      ' 5-23-1983',
      36.341709,
      NULL,
      54.199512,
      16,
      7.061973,
      8.270223,
      NULL,
      4.502464,
      30.365876,
      NULL,
      45,
      25,
      22,
      5.802172,
      24.234216,
      NULL,
      NULL,
      6,
      73.953054,
      27,
      10,
      20,
      39.795169,
      15,
      1,
      NULL,
      177,
      7,
      66,
      NULL,
      NULL,
      '11-23-1990',
      1,
      68,
      9.885128,
      31,
      70,
      NULL,
      ' 1- 0-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.678585,
      10.827288,
      3,
      NULL,
      2,
      11,
      ' 8- 3-1980',
      1.044292,
      1.598264,
      157.765310,
      NULL,
      1,
      94.803172,
      1,
      1,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      19.473955,
      61,
      35.067169,
      38.065188,
      NULL,
      NULL,
      NULL,
      NULL,
      30.214668,
      75,
      NULL,
      ' 5-24-1974',
      20.119166,
      NULL,
      4,
      80.623026,
      39,
      51,
      10,
      ' 0-23-1997',
      NULL,
      NULL,
      ' 3-21-1989',
      1.975229,
      13.861180,
      14.441147,
      NULL,
      11,
      4.779656,
      NULL,
      24,
      0,
      NULL,
      0.943362,
      3.698965,
      11,
      NULL,
      0.409090,
      0.980605,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      81,
      1,
      ' 8- 8-1975',
      NULL,
      NULL,
      NULL,
      1.327535,
      ' 2-18-1998',
      26.886610,
      ' 6-12-1991',
      5.787612,
      2,
      ' 5-23-1975',
      61.686041,
      35.429918,
      ' 1-26-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      19,
      ' 0-22-1998',
      21.495461,
      39.365965,
      22.054829,
      ' 4-11-1982',
      1,
      120,
      ' 2-18-1995',
      6,
      7,
      5,
      25,
      ' 3-20-1992',
      NULL,
      NULL,
      NULL,
      ' 9-25-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


