set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '3',
      '3',
      '2',
      NULL,
      NULL,
      '0',
      '1',
      '4',
      '3',
      '0',
      '4',
      '1',
      '2',
      NULL,
      '3',
      '0',
      '0',
      '4',
      '3',
      '2',
      '4',
      '3',
      '',
      '0',
      NULL,
      '1',
      '1',
      '0',
      NULL,
      '0',
      NULL,
      '',
      '0',
      '4',
      '4',
      NULL,
      '1',
      '3',
      NULL,
      '0',
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      NULL,
      14,
      '1443222',
      0.358910,
      101,
      2,
      NULL,
      '434244',
      0,
      ' 8- 4-1976',
      ' 3- 3-1985',
      75.946749,
      20,
      NULL,
      NULL,
      18.082030,
      15.082320,
      114,
      20.726996,
      6,
      6.659465,
      31,
      21,
      NULL,
      0,
      4.228405,
      11,
      9.605763,
      1,
      NULL,
      29,
      15.624709,
      20,
      NULL,
      6,
      NULL,
      61.233505,
      206,
      32.966489,
      69.580265,
      95,
      109,
      ' 0-21-2003',
      47.960617,
      12.566375,
      8.048708,
      1,
      4.928974,
      246,
      '10-23-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.523777,
      NULL,
      5,
      NULL,
      6.195557,
      '10-29-2003',
      1.485460,
      0,
      NULL,
      1,
      1,
      13.608428,
      0.059240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-29-1996',
      26,
      24.022927,
      7,
      16,
      73,
      56,
      85,
      NULL,
      NULL,
      46,
      NULL,
      50,
      ' 2-23-1990',
      21,
      0.487836,
      12,
      27.881086,
      NULL,
      24,
      4.646662,
      ' 2-11-1977',
      24,
      9.716082,
      NULL,
      12,
      NULL,
      10,
      17.397811,
      21.443929,
      1,
      0,
      NULL,
      0,
      23.491238,
      NULL,
      1,
      10.471451,
      18,
      8,
      4.714431,
      1,
      0.326431,
      ' 0-16-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      141,
      0,
      '11- 2-1978',
      NULL,
      NULL,
      NULL,
      26.227968,
      ' 8-20-1986',
      NULL,
      ' 5-17-1986',
      12,
      12,
      ' 4-24-1994',
      65.431878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      17,
      ' 2-21-1987',
      63,
      NULL,
      35,
      NULL,
      3,
      0.424339,
      ' 4-28-1993',
      16,
      NULL,
      NULL,
      4.456156,
      NULL,
      20,
      1,
      NULL,
      ' 9-16-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


