set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6505780';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0433',
      '42100404',
      '03434420',
      '23423204',
      '32212112',
      '11223103',
      '33040012',
      NULL,
      '31443140',
      '33104041',
      NULL,
      '22202303',
      '34120441',
      '12222322',
      '11324203',
      '32341101',
      '21300311',
      '02201440',
      NULL,
      '33200330',
      '31301403',
      '14234412',
      '30040212',
      '21113144',
      NULL,
      NULL,
      '42032204',
      NULL,
      '43044000',
      '32042124',
      '32001423',
      '43122444',
      '11233303',
      NULL,
      '40244110',
      '00412401',
      '31404120',
      '30311404',
      '41130410',
      NULL,
      '11244204',
      '44130430',
      '32100401',
      '22023123',
      '20140010',
      '414',
      '44',
      NULL,
      NULL,
      '3444341',
      0.055425,
      0.485359,
      1,
      NULL,
      '041001',
      5,
      ' 1- 3-1996',
      ' 7- 0-1984',
      104,
      NULL,
      NULL,
      7.816390,
      5.904302,
      NULL,
      NULL,
      20.636909,
      24.228083,
      NULL,
      7.948874,
      NULL,
      36,
      18,
      9,
      0.738386,
      0,
      5,
      45.224508,
      10.597129,
      15.083629,
      1.770678,
      15,
      8,
      0,
      NULL,
      178,
      NULL,
      142,
      41,
      NULL,
      ' 5- 2-1980',
      44,
      1,
      35,
      17,
      118,
      107,
      ' 4-12-1988',
      6,
      NULL,
      2,
      1,
      1.523206,
      NULL,
      7.618811,
      1,
      NULL,
      1,
      0.696181,
      1,
      0.749247,
      1.173309,
      0.589550,
      1,
      1.452674,
      1.533970,
      NULL,
      0.495182,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-18-1992',
      51,
      20,
      NULL,
      1,
      24.835511,
      0.715596,
      '10-19-1993',
      0,
      1.785863,
      NULL,
      0.462590,
      1,
      111,
      1.021386,
      3.523214,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 0-1993',
      78,
      29,
      69,
      15.650536,
      11.061412,
      54.198978,
      31,
      NULL,
      46.221679,
      1.667421,
      NULL,
      7,
      ' 9-10-2000',
      0.432238,
      20,
      1.707713,
      38,
      47,
      NULL,
      3.626182,
      NULL,
      NULL,
      7.139971,
      ' 8- 6-1997',
      8.335931,
      16.013063,
      18.011892,
      1.138459,
      3.619192,
      13.660605,
      3,
      2,
      1,
      77,
      6,
      1,
      8,
      27,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      139.230957,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 3-2001',
      33,
      ' 7-14-1989',
      10.553678,
      16.412188,
      ' 8- 1-1990',
      26.821988,
      40,
      ' 3-28-1992',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      ' 9-26-1976',
      66,
      40.966817,
      18,
      ' 0- 2-1977',
      0,
      103,
      ' 3- 8-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


