set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32401123',
      NULL,
      '02030140',
      NULL,
      NULL,
      '02300212',
      NULL,
      '12241410',
      '03440123',
      NULL,
      NULL,
      '00142212',
      '22131140',
      '44021401',
      '23343310',
      NULL,
      '00101300',
      '31122212',
      NULL,
      '04012434',
      NULL,
      '34340313',
      '12440131',
      '22312213',
      '22103200',
      '43020124',
      '31143002',
      '44030401',
      '24024010',
      '32010030',
      '24220334',
      '40434220',
      '00232203',
      '03343302',
      '31034413',
      '20033400',
      NULL,
      '41121430',
      '21322314',
      '04444143',
      NULL,
      '04000333',
      '03020403',
      '10304411',
      '412',
      NULL,
      NULL,
      2,
      '4433124',
      2,
      1.535126,
      1,
      NULL,
      '030302',
      3.470767,
      ' 4-28-2001',
      ' 8-28-1994',
      59,
      88,
      21,
      13,
      13.626923,
      17.676130,
      82,
      0.183878,
      1,
      7.673308,
      20.983182,
      11,
      0,
      15,
      NULL,
      10.103494,
      1.987082,
      1.077147,
      10.582781,
      5.160843,
      40.396001,
      NULL,
      39,
      3.641875,
      1.506707,
      NULL,
      139,
      39.032353,
      131,
      NULL,
      183.634450,
      ' 6-21-1974',
      1.271650,
      NULL,
      11,
      3,
      64.876381,
      183.546838,
      '11-11-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      29,
      5,
      NULL,
      1,
      ' 2-20-1991',
      NULL,
      NULL,
      155.483407,
      0,
      3,
      5,
      0.938105,
      1.089724,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-18-1986',
      68,
      8.165378,
      80.245523,
      NULL,
      39.067205,
      77,
      NULL,
      NULL,
      2,
      24.878156,
      21,
      58.406231,
      '11-10-1992',
      14.809880,
      10.680048,
      18.647497,
      NULL,
      16.188403,
      NULL,
      9.282274,
      NULL,
      14,
      8,
      ' 7-22-1974',
      5,
      8,
      1.315046,
      NULL,
      NULL,
      0.648263,
      1,
      NULL,
      0,
      58.485568,
      1.478642,
      6.504803,
      NULL,
      NULL,
      3,
      NULL,
      1.022340,
      0,
      ' 4-28-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      34.849554,
      8.047366,
      ' 0-20-1982',
      NULL,
      NULL,
      NULL,
      5.138370,
      ' 0-27-1999',
      12,
      ' 4-21-1978',
      5,
      NULL,
      ' 7-23-1994',
      66,
      108,
      '11-16-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      9,
      ' 8-28-1993',
      40.150583,
      NULL,
      NULL,
      ' 7- 3-1977',
      1.488089,
      131.988605,
      ' 1-17-1983',
      7.356327,
      9,
      NULL,
      NULL,
      ' 4- 9-1977',
      38,
      0.713754,
      NULL,
      ' 6-25-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


