set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9233337';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4201',
      '12223433',
      '42414310',
      '44032101',
      '30120403',
      NULL,
      '00131210',
      '30300222',
      NULL,
      '33140341',
      '14444442',
      '24233414',
      '10013422',
      '43211421',
      '41142224',
      '41303014',
      '41132334',
      '43042014',
      '00114322',
      '03023122',
      NULL,
      '41123310',
      '44004422',
      '31241023',
      '11424313',
      '40204001',
      '04122222',
      '43303034',
      '30012313',
      '20014142',
      '22332214',
      '04401141',
      '43044411',
      '12120423',
      '12011102',
      NULL,
      '21023214',
      '20420231',
      NULL,
      '43042431',
      '20020113',
      '41331431',
      '11321304',
      '30012132',
      '30401302',
      '400',
      '01',
      NULL,
      NULL,
      NULL,
      1,
      1.542758,
      2,
      NULL,
      '333243',
      4.469924,
      ' 6-21-1989',
      ' 9-10-1998',
      15.028400,
      NULL,
      27,
      NULL,
      19,
      22,
      38,
      NULL,
      8.639962,
      2,
      7.264762,
      20,
      45,
      12,
      35.409699,
      0.891402,
      NULL,
      9,
      NULL,
      1.603389,
      39.549699,
      18,
      89.185576,
      4,
      NULL,
      NULL,
      161,
      NULL,
      169.251826,
      197,
      NULL,
      ' 3-20-1980',
      14,
      7.490924,
      NULL,
      NULL,
      43,
      NULL,
      ' 0-12-1977',
      1,
      1.630874,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.215343,
      NULL,
      1,
      0,
      1.873881,
      6,
      0.132470,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      143,
      1,
      2.806157,
      54,
      NULL,
      NULL,
      9.562437,
      NULL,
      0.132526,
      NULL,
      NULL,
      15.756036,
      80,
      105.558213,
      91,
      23,
      101,
      NULL,
      NULL,
      8,
      67.660177,
      38,
      NULL,
      ' 7-27-1988',
      11,
      39.616163,
      14,
      84,
      111,
      176,
      6.503565,
      ' 5- 9-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.689994,
      9.501962,
      NULL,
      NULL,
      53,
      1,
      ' 7- 5-1977',
      NULL,
      8.100404,
      ' 3-22-2003',
      26.540729,
      '10-22-2001',
      24,
      ' 9-13-1984',
      13,
      7.609812,
      '11- 3-2000',
      92.851709,
      NULL,
      ' 5-12-1977',
      13,
      9.589369,
      ' 7-19-1999',
      2,
      NULL,
      ' 7-13-1991',
      0,
      NULL,
      16.565643,
      ' 4-22-1977',
      57.970871,
      26,
      29,
      ' 6-29-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964085);
commit;
end;
/


