set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8713973';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '00411320',
      NULL,
      '44221322',
      '40430414',
      '10344221',
      '31044100',
      '02302011',
      '22440420',
      '43304213',
      '03402132',
      '33400310',
      '42101100',
      '44021243',
      '21414403',
      '00433010',
      '21320312',
      '11240111',
      NULL,
      '20344344',
      '04131124',
      '04322434',
      NULL,
      '42342121',
      '10000244',
      '40233413',
      '44213343',
      '24304440',
      '24122102',
      '04410042',
      '40421044',
      '30431001',
      '23413124',
      '24344320',
      '30114300',
      '24410101',
      '31121200',
      NULL,
      '04134131',
      '21242440',
      '04043442',
      '13034113',
      NULL,
      '33314134',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.224024,
      1.390225,
      2,
      NULL,
      '300323',
      3.984189,
      ' 8-10-1976',
      ' 0- 2-1996',
      37,
      NULL,
      7,
      13.515604,
      15.337824,
      9.311257,
      NULL,
      NULL,
      13.936114,
      3,
      32.205458,
      11.418743,
      4,
      0.522178,
      34,
      19,
      1.733241,
      NULL,
      62.571235,
      15.626932,
      16,
      NULL,
      38.467689,
      14.408910,
      0.004530,
      140.841574,
      154,
      66,
      234,
      94.696035,
      44,
      NULL,
      28.781800,
      8.881072,
      28,
      28,
      NULL,
      NULL,
      NULL,
      4,
      8,
      2.081521,
      1.375480,
      0,
      5,
      1.139585,
      2.205343,
      NULL,
      1.539715,
      1,
      0,
      1,
      4,
      NULL,
      0,
      0,
      1.220396,
      0,
      0.999587,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-15-1977',
      NULL,
      NULL,
      NULL,
      4,
      3,
      6,
      ' 0- 7-2003',
      1.348715,
      0.981211,
      NULL,
      1,
      1,
      49.981497,
      NULL,
      4,
      20,
      NULL,
      NULL,
      NULL,
      ' 9-14-1989',
      48.043914,
      3.741798,
      55,
      0,
      90.930674,
      34.078952,
      12,
      19,
      81,
      93.294336,
      20.362292,
      41.239679,
      ' 1- 7-1993',
      18,
      1,
      17.200116,
      22.758595,
      14,
      7.978763,
      4.921378,
      ' 4- 0-2003',
      NULL,
      NULL,
      ' 6-25-1983',
      10,
      12.103852,
      5.212421,
      23,
      9,
      12.382024,
      1,
      8.064967,
      1.499390,
      28,
      0,
      0.131507,
      8.608869,
      9.391015,
      1,
      1.334113,
      NULL,
      1,
      NULL,
      0.859926,
      3,
      8.204368,
      ' 9-22-1991',
      115,
      1.944544,
      ' 9-16-1988',
      NULL,
      19.625468,
      ' 0- 5-1990',
      NULL,
      NULL,
      NULL,
      '11-26-1980',
      12.717309,
      1,
      ' 4- 3-1995',
      NULL,
      NULL,
      ' 3-27-1984',
      NULL,
      2.350892,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      12.842047,
      NULL,
      27,
      26.807779,
      NULL,
      ' 1- 3-1991',
      0,
      33,
      ' 4- 3-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9);
commit;
end;
/


