set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7837432';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3310',
      '13303102',
      '22020134',
      '42133043',
      '41114031',
      '14413114',
      '24403022',
      '30100303',
      '00322013',
      '41432421',
      '12234143',
      '44321334',
      '32230141',
      '04433241',
      '34302340',
      '02121434',
      NULL,
      '44400113',
      '03033123',
      NULL,
      '20133440',
      '42442012',
      '12213402',
      '21421343',
      '11442131',
      '12401301',
      '24323311',
      '34113321',
      '14230110',
      '21140310',
      '31411220',
      NULL,
      NULL,
      '14302212',
      NULL,
      '11141333',
      '43224432',
      '41100003',
      '03332120',
      '42014432',
      '43302230',
      '10431131',
      '42040443',
      '43143434',
      '32244042',
      '210',
      '04',
      2.769477,
      22,
      NULL,
      1,
      0,
      NULL,
      NULL,
      '401003',
      1,
      ' 6- 2-2003',
      ' 6-28-1998',
      34.263423,
      108,
      13,
      0,
      3,
      10,
      24,
      18.073023,
      29.806078,
      15.386506,
      38,
      19,
      35,
      4,
      7,
      19,
      26,
      15.154019,
      NULL,
      3,
      21.760791,
      2.108936,
      NULL,
      7,
      0,
      107.847016,
      89.050108,
      5.041602,
      123,
      NULL,
      119,
      NULL,
      53.506912,
      21.543956,
      22.568183,
      NULL,
      2.161630,
      27,
      ' 1-15-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      6.065343,
      13.177902,
      NULL,
      ' 5- 7-1990',
      1,
      1,
      0.612865,
      0,
      3,
      NULL,
      1,
      1,
      113,
      NULL,
      NULL,
      NULL,
      ' 4-14-1981',
      102.555879,
      38.403526,
      124.151379,
      0,
      11.416543,
      NULL,
      25,
      47,
      NULL,
      73.983004,
      77,
      58.403135,
      NULL,
      8.708563,
      7,
      30.814606,
      120.797024,
      39.551948,
      104,
      13,
      ' 0-23-1974',
      28,
      16.733071,
      ' 5-13-1977',
      10,
      10.042073,
      9.763543,
      20,
      NULL,
      5,
      NULL,
      11.858230,
      1.798932,
      36,
      8,
      1,
      5,
      9.625627,
      12,
      9.991447,
      0,
      3,
      ' 4-16-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      58.391737,
      16,
      ' 2-15-1981',
      NULL,
      NULL,
      NULL,
      15,
      ' 7- 2-1997',
      NULL,
      ' 1- 3-1992',
      11,
      NULL,
      ' 4- 7-2003',
      61.125174,
      0,
      ' 9-10-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      ' 2-24-1990',
      50,
      10,
      14.040458,
      ' 8-12-2000',
      3.668068,
      87,
      ' 2-18-1988',
      10.255733,
      9,
      21,
      13,
      ' 6- 8-1996',
      47.093528,
      1,
      8.206406,
      ' 9-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


