set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41302444',
      '20310404',
      NULL,
      '04024343',
      '43404401',
      NULL,
      '04010233',
      '44233434',
      '03342403',
      '43043121',
      '03210242',
      '21401101',
      NULL,
      '41034030',
      '20224101',
      '04240324',
      '12134434',
      '33300321',
      '00420240',
      '34001433',
      NULL,
      '33204411',
      NULL,
      '44301044',
      '34100303',
      '10304100',
      NULL,
      '10311030',
      '31413442',
      '32033000',
      NULL,
      '21432002',
      '31434000',
      '12322433',
      '21332130',
      '24110133',
      '41014324',
      '02120142',
      '40301113',
      '42420401',
      '41132030',
      '20444232',
      '00300323',
      '02101432',
      '120',
      '22',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4.583999,
      NULL,
      NULL,
      84.740133,
      NULL,
      14.940349,
      4,
      20,
      2.193361,
      8,
      6.377408,
      12,
      11.889606,
      10.454141,
      7,
      NULL,
      NULL,
      13,
      1.965042,
      2,
      7,
      28,
      10.530048,
      15.704940,
      9,
      87,
      12,
      1.859064,
      71.302325,
      NULL,
      1,
      137.697683,
      62.156559,
      NULL,
      ' 0-15-1997',
      23,
      43.325250,
      23,
      9.323038,
      54,
      98.149596,
      '11-27-2003',
      4,
      3,
      0.875481,
      1.220248,
      0,
      3.417307,
      NULL,
      8.380179,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      7.521854,
      NULL,
      1.753835,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 4-2003',
      NULL,
      16.751818,
      17.270600,
      0,
      NULL,
      NULL,
      ' 8-22-1985',
      0,
      0,
      NULL,
      1.690042,
      NULL,
      33,
      0.472681,
      0,
      36.276696,
      NULL,
      NULL,
      NULL,
      ' 0-24-1984',
      4,
      56.884727,
      NULL,
      41,
      63.055022,
      22,
      NULL,
      NULL,
      NULL,
      20.245091,
      NULL,
      NULL,
      ' 3- 6-2000',
      7.893856,
      13,
      7.449504,
      NULL,
      3,
      NULL,
      0.303583,
      NULL,
      3.057679,
      6.324766,
      ' 3-19-1981',
      8.802528,
      NULL,
      NULL,
      13.616698,
      7.106090,
      2,
      0,
      12.769767,
      NULL,
      111,
      NULL,
      6,
      18,
      9.268821,
      0.761965,
      NULL,
      2,
      0.912392,
      ' 0- 8-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926425,
      NULL,
      17,
      ' 6-27-1987',
      NULL,
      10.913436,
      ' 3-28-1998',
      2.824598,
      3.510878,
      ' 2-17-1989',
      NULL,
      NULL,
      ' 7-20-2002',
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.296477,
      ' 3- 3-2003',
      13,
      NULL,
      14.917536,
      ' 1-21-1979',
      0,
      1.416779,
      ' 8-14-1989',
      15.665934,
      41,
      18,
      21.203497,
      NULL,
      56,
      1.160071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


