set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9930512';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '4',
      NULL,
      '4',
      '3',
      '0',
      '0',
      '3',
      '4',
      '2',
      '2',
      '0',
      '3',
      '1',
      '3',
      '1',
      '2',
      '0',
      '4',
      '2',
      '1',
      NULL,
      '4',
      '',
      '1',
      '',
      NULL,
      '3',
      '0',
      '4',
      NULL,
      '',
      '',
      '3',
      '0',
      '2',
      '1',
      NULL,
      '4',
      NULL,
      NULL,
      '1',
      '2',
      '0',
      '000',
      '22403110',
      NULL,
      30.500276,
      NULL,
      2.611871,
      1,
      2,
      NULL,
      '344000',
      3.668693,
      ' 3-15-1988',
      ' 5-11-1998',
      100.795633,
      NULL,
      4,
      7.221221,
      11.101494,
      NULL,
      32.942725,
      6,
      2.437503,
      12.237521,
      17.165439,
      2,
      21,
      2,
      22,
      4,
      28,
      11,
      78,
      25,
      27.271145,
      8,
      35,
      2,
      1,
      65.439569,
      71.803329,
      76.889871,
      NULL,
      69.410060,
      177.076827,
      NULL,
      11,
      18.054032,
      11.551823,
      9,
      83,
      124,
      '11-21-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      90,
      4,
      1,
      8,
      5,
      4.729962,
      '10-27-2003',
      1.692606,
      0.776442,
      141,
      NULL,
      1,
      97,
      2.635330,
      0.793289,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 3-1974',
      NULL,
      NULL,
      94,
      NULL,
      NULL,
      4.576578,
      93.105690,
      29,
      32.726384,
      54,
      63,
      18,
      ' 4-10-2002',
      NULL,
      21,
      7,
      7.214900,
      NULL,
      130,
      14.299550,
      NULL,
      NULL,
      18,
      '11-21-1978',
      8.507247,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0.954034,
      NULL,
      1,
      102,
      2,
      1,
      20.071232,
      NULL,
      0,
      0.824861,
      NULL,
      0.921463,
      ' 7- 2-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      '11-27-1985',
      NULL,
      NULL,
      NULL,
      44.206522,
      ' 4-16-1977',
      2,
      ' 0-20-1974',
      10.211369,
      12,
      ' 7-25-2002',
      25.749427,
      NULL,
      ' 2-26-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.297515,
      ' 1- 9-1987',
      NULL,
      NULL,
      51,
      ' 8-12-1974',
      0.186530,
      83.556972,
      ' 5-12-1992',
      4.932990,
      17.589311,
      2.673658,
      NULL,
      '10- 2-1992',
      37.709988,
      1,
      41.787051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


