set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9930512';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      '2',
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '3',
      '1',
      '1',
      '1',
      '1',
      '0',
      '4',
      '3',
      NULL,
      '2',
      '4',
      '3',
      '2',
      NULL,
      '4',
      '0',
      '',
      '3',
      '',
      '0',
      '4',
      '3',
      '2',
      NULL,
      '',
      NULL,
      '0',
      NULL,
      '4',
      NULL,
      '1',
      '3',
      '1',
      '4',
      '2',
      '0',
      '4',
      '140',
      NULL,
      86,
      28.896084,
      '1123042',
      3,
      30.016028,
      3,
      1,
      '200212',
      NULL,
      '10- 8-1986',
      NULL,
      23,
      8.706195,
      26,
      3.035692,
      12.194732,
      11,
      40,
      10.172844,
      7,
      15.184132,
      8.598475,
      1,
      NULL,
      NULL,
      2,
      8,
      8,
      27.683200,
      NULL,
      NULL,
      71,
      7.535730,
      44,
      4,
      NULL,
      NULL,
      51.030745,
      21.587069,
      152.434306,
      86.809538,
      NULL,
      '11-13-1996',
      31.573013,
      10.850160,
      29.578686,
      25.883444,
      NULL,
      26.759834,
      '11-15-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.023595,
      22.248299,
      19,
      16,
      27,
      NULL,
      ' 6- 9-1990',
      1.627253,
      1.835983,
      122,
      0.690361,
      1.841138,
      5,
      1,
      0.333166,
      28,
      NULL,
      NULL,
      NULL,
      ' 0-24-1998',
      NULL,
      50,
      89.696906,
      87.934454,
      NULL,
      13,
      NULL,
      NULL,
      58,
      NULL,
      1.302337,
      34,
      ' 9-22-1974',
      15,
      NULL,
      0,
      NULL,
      25,
      94,
      NULL,
      ' 1-14-1995',
      NULL,
      1.445769,
      NULL,
      7,
      8.754918,
      4,
      20,
      17.475436,
      2.572639,
      NULL,
      NULL,
      1,
      51.610386,
      NULL,
      0,
      7,
      10,
      0,
      NULL,
      NULL,
      1.262552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-20-1978',
      NULL,
      NULL,
      NULL,
      46.218752,
      ' 2-14-1992',
      40.647085,
      NULL,
      13.169730,
      5,
      ' 5-16-1987',
      51,
      61,
      ' 8-25-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11.787391,
      ' 3-14-1998',
      72.658129,
      NULL,
      42.377443,
      NULL,
      2,
      62.098159,
      ' 1-17-1999',
      5.080628,
      27.782069,
      14.820620,
      0,
      ' 5-22-1992',
      50,
      1,
      NULL,
      ' 5- 9-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


