set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9758171';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      '1',
      '1',
      '1',
      '0',
      '2',
      '3',
      NULL,
      '1',
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      '1',
      NULL,
      '0',
      '3',
      '1',
      '4',
      '4',
      '3',
      '',
      '1',
      '',
      '4',
      '2',
      '1',
      '4',
      '1',
      NULL,
      '',
      '4',
      '3',
      '1',
      '0',
      '1',
      '4',
      '4',
      '1',
      '1',
      '0',
      '1',
      NULL,
      NULL,
      4,
      39,
      '2230323',
      NULL,
      NULL,
      NULL,
      NULL,
      '302432',
      NULL,
      ' 9-24-1985',
      ' 5- 8-2002',
      100,
      118,
      15.905461,
      12,
      NULL,
      6,
      28,
      NULL,
      6.789140,
      11,
      NULL,
      9.705130,
      29,
      15,
      20,
      5.366975,
      NULL,
      NULL,
      36.357674,
      0,
      NULL,
      19.172910,
      65.088426,
      NULL,
      1,
      NULL,
      78,
      NULL,
      133,
      120,
      162,
      ' 0-19-1992',
      44.684002,
      13.971632,
      NULL,
      25.328089,
      178.438193,
      205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      17.234202,
      NULL,
      NULL,
      9.066783,
      ' 3-19-1974',
      1.907385,
      1.755657,
      61,
      NULL,
      NULL,
      72,
      1,
      0,
      47.244958,
      NULL,
      NULL,
      NULL,
      ' 6-28-1982',
      27,
      NULL,
      53.601571,
      18,
      NULL,
      48.510210,
      NULL,
      46,
      NULL,
      12,
      11,
      NULL,
      NULL,
      NULL,
      4,
      2.199848,
      25.522176,
      NULL,
      14.917261,
      7.187278,
      ' 2-27-1989',
      NULL,
      16.953006,
      ' 1- 3-2003',
      NULL,
      3.259532,
      6,
      NULL,
      3.141357,
      0.583847,
      NULL,
      NULL,
      1,
      20,
      NULL,
      0.744219,
      NULL,
      9,
      7,
      7,
      0.135653,
      1.950547,
      ' 1-28-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      0.921060,
      NULL,
      '10- 1-1985',
      NULL,
      NULL,
      NULL,
      24,
      ' 0- 6-2001',
      5.905994,
      ' 2-21-1997',
      1.378909,
      2,
      ' 2-27-1993',
      148.183297,
      75,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '11-26-1982',
      51.452547,
      27,
      41,
      NULL,
      5,
      129.736580,
      ' 6- 7-1980',
      2.997574,
      NULL,
      4,
      NULL,
      ' 8-13-1993',
      9,
      NULL,
      131,
      ' 8-13-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


