set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9758171';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '3',
      '1',
      '4',
      '3',
      '2',
      '3',
      '3',
      '4',
      '3',
      '4',
      '2',
      '3',
      '1',
      '2',
      NULL,
      '0',
      '3',
      '4',
      '1',
      '0',
      NULL,
      NULL,
      '',
      '2',
      '4',
      '3',
      NULL,
      NULL,
      '',
      NULL,
      '1',
      '0',
      '3',
      '1',
      '4',
      '4',
      NULL,
      '2',
      '4',
      '3',
      '2',
      NULL,
      '02433433',
      3.818848,
      38.511584,
      NULL,
      0,
      41.959554,
      2,
      NULL,
      NULL,
      1,
      NULL,
      '11-26-1977',
      15,
      282.023680,
      31,
      18,
      9.073074,
      NULL,
      95.453452,
      13,
      20.201039,
      11.230346,
      NULL,
      NULL,
      42,
      8,
      28.134451,
      10,
      0,
      25.389044,
      NULL,
      16,
      59,
      NULL,
      125,
      14,
      1.886671,
      108,
      NULL,
      66,
      NULL,
      22,
      100,
      NULL,
      18,
      35,
      4,
      23.477408,
      112,
      83.046362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.570319,
      NULL,
      4.860154,
      6,
      ' 7-21-1976',
      1,
      NULL,
      99.886194,
      NULL,
      NULL,
      NULL,
      0.797567,
      1,
      84.216451,
      NULL,
      NULL,
      NULL,
      '11-14-1997',
      NULL,
      8.795877,
      103,
      NULL,
      76,
      104.268060,
      34.102564,
      38.227029,
      NULL,
      29.665042,
      34,
      NULL,
      NULL,
      0,
      2.769905,
      16,
      19.943083,
      21.507386,
      16.330469,
      2,
      ' 4-24-1986',
      0.620116,
      21.707949,
      ' 5- 9-1988',
      NULL,
      18.397098,
      NULL,
      24.039216,
      5.732000,
      10,
      NULL,
      20.464658,
      1.318608,
      121,
      0.690466,
      6.483467,
      7.725670,
      31,
      NULL,
      1.685948,
      1.652010,
      0,
      ' 1-23-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      160.972854,
      1,
      '11- 6-1997',
      NULL,
      NULL,
      NULL,
      21.647126,
      NULL,
      45,
      ' 4-15-1997',
      8,
      6.842216,
      ' 6-29-1976',
      40,
      56,
      ' 6- 7-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      49.560095,
      12,
      NULL,
      NULL,
      1,
      49.145683,
      '11-11-1986',
      16.148458,
      6,
      0.589012,
      7,
      ' 5-16-1974',
      31.020963,
      1,
      21.001809,
      ' 3-17-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


