set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9758171';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '1',
      '4',
      '1',
      '1',
      NULL,
      '0',
      '2',
      '0',
      '2',
      '4',
      '2',
      '4',
      '2',
      '0',
      NULL,
      '4',
      '1',
      '3',
      '0',
      '4',
      '2',
      NULL,
      '',
      '4',
      '',
      '2',
      NULL,
      '0',
      '2',
      NULL,
      '',
      '',
      NULL,
      '3',
      '3',
      '4',
      NULL,
      '3',
      '0',
      '2',
      '4',
      '3',
      '1',
      '421',
      '43430201',
      35.268611,
      89,
      '0343031',
      3.674423,
      9,
      3,
      1,
      '331134',
      0,
      ' 0-17-1986',
      ' 7- 6-1988',
      NULL,
      14.701041,
      18.371215,
      NULL,
      9.744453,
      16,
      26,
      3,
      8,
      18.668368,
      36,
      17.699834,
      46.172672,
      17.060748,
      NULL,
      19,
      5,
      7.597239,
      9.504695,
      NULL,
      13.079297,
      0.707730,
      81,
      17.023425,
      1,
      14,
      154.860493,
      10,
      81.776654,
      232,
      153,
      ' 8-15-2003',
      18.450949,
      NULL,
      2.426467,
      6.823906,
      197,
      105.849517,
      '11- 3-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      102,
      5,
      7.886888,
      0,
      2.154335,
      2,
      ' 4- 2-1997',
      0,
      1,
      NULL,
      NULL,
      0.126168,
      28,
      NULL,
      1.426189,
      53,
      NULL,
      NULL,
      NULL,
      ' 3-26-2000',
      1.753696,
      71.293645,
      116.699796,
      7.284601,
      11.791339,
      77.546163,
      45.522145,
      82,
      3,
      NULL,
      39,
      59.209364,
      ' 7-26-1983',
      4,
      0,
      4.306279,
      22.341245,
      24,
      0.662771,
      2.757673,
      ' 4-27-1990',
      27.185666,
      NULL,
      ' 5-17-1976',
      3,
      3.796994,
      12.599947,
      7,
      NULL,
      NULL,
      1,
      NULL,
      1.586974,
      55,
      1,
      0,
      12,
      NULL,
      7,
      0.182304,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      230.909822,
      NULL,
      ' 1-10-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-19-1985',
      7,
      ' 7- 0-1975',
      NULL,
      12.457490,
      NULL,
      67,
      8.555922,
      ' 5-23-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      17.439920,
      '11-28-2003',
      49,
      2,
      NULL,
      '11-26-1994',
      1,
      49.081395,
      ' 6- 2-1976',
      NULL,
      2,
      21.415677,
      NULL,
      ' 6- 2-1978',
      37.323825,
      1,
      125.644672,
      ' 7-25-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


