set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7613825';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      '2',
      '1',
      NULL,
      '1',
      '0',
      '4',
      '4',
      '1',
      '0',
      '0',
      NULL,
      '2',
      NULL,
      '2',
      NULL,
      '1',
      '2',
      '2',
      '4',
      '2',
      NULL,
      NULL,
      '2',
      '',
      '1',
      '4',
      '4',
      '0',
      NULL,
      '',
      '',
      '1',
      '4',
      '4',
      '1',
      '3',
      '4',
      '0',
      '4',
      '1',
      '2',
      NULL,
      NULL,
      '43114311',
      43,
      NULL,
      '2311111',
      2,
      NULL,
      NULL,
      NULL,
      '113213',
      0,
      NULL,
      ' 2- 3-1982',
      10,
      98.863722,
      NULL,
      14,
      18.688723,
      NULL,
      74,
      26,
      11.162341,
      5.291407,
      NULL,
      8,
      39,
      15.558592,
      34,
      9,
      2,
      30,
      54.440188,
      3,
      52,
      10,
      43,
      29.998636,
      1.515073,
      126.919138,
      129.231479,
      65,
      162,
      27.767031,
      153.679662,
      ' 5-11-1988',
      55.012039,
      15,
      5.937290,
      17.667154,
      NULL,
      19.488622,
      ' 1-24-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      10.037261,
      0,
      0.335869,
      8,
      '11-13-1978',
      0.705019,
      NULL,
      36.445989,
      0,
      0,
      49.746911,
      3.512204,
      0,
      40.226548,
      NULL,
      NULL,
      NULL,
      ' 0- 6-1983',
      36.108827,
      96.311044,
      10,
      101.718325,
      83.705564,
      66.919811,
      33,
      32,
      NULL,
      NULL,
      33,
      97.975284,
      ' 5-24-1977',
      3,
      18,
      17.972980,
      37,
      18.204832,
      9.440139,
      0.188151,
      ' 7- 6-1981',
      11.009415,
      15,
      ' 6-21-1975',
      6.403481,
      27,
      10,
      4,
      22,
      11,
      NULL,
      12.516108,
      1,
      103.411393,
      1.287358,
      0.636640,
      NULL,
      8,
      3.383178,
      1,
      1,
      1,
      ' 3- 1-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      0,
      ' 5-21-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-15-1994',
      NULL,
      '11-28-1981',
      1.287849,
      9,
      '10-22-1978',
      38.703061,
      97,
      ' 9-28-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      28,
      NULL,
      31.300890,
      41,
      32,
      '11-15-1983',
      3,
      NULL,
      ' 9- 5-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


