set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9430524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31122241',
      NULL,
      '01014300',
      '41413314',
      NULL,
      '42022221',
      '43200143',
      '24030424',
      '42214403',
      NULL,
      NULL,
      '04021323',
      '14202121',
      '10322030',
      NULL,
      '23030333',
      '14203032',
      NULL,
      '14130421',
      '40310140',
      '30024041',
      '20223201',
      '44234342',
      '23444312',
      '31223342',
      '32233234',
      NULL,
      '04211041',
      '32431043',
      '30301440',
      '01441413',
      '02333040',
      '20332202',
      '20102013',
      NULL,
      '01410042',
      '40411422',
      '24024014',
      NULL,
      NULL,
      NULL,
      '32410043',
      '40334310',
      '31440430',
      '332',
      '23',
      NULL,
      NULL,
      '4230124',
      2.705935,
      NULL,
      2,
      NULL,
      '214211',
      1,
      ' 6-20-1984',
      NULL,
      13,
      NULL,
      NULL,
      4.596138,
      4,
      7.747178,
      25.708285,
      8.521804,
      NULL,
      0.750073,
      12.881955,
      NULL,
      19.441311,
      12.540148,
      3.583944,
      2,
      8,
      3.783580,
      5.382974,
      20.795972,
      18.719602,
      22,
      39,
      0,
      1.128387,
      NULL,
      NULL,
      10,
      88,
      79.520722,
      68.033172,
      ' 2-19-1989',
      38.036752,
      1,
      21.251571,
      NULL,
      12,
      155.911811,
      ' 9- 0-1979',
      1,
      5.214759,
      NULL,
      4.034784,
      6,
      16.322453,
      NULL,
      3,
      1.753658,
      1.985166,
      NULL,
      1,
      0,
      5.478012,
      0.071388,
      1,
      5,
      1.910938,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-18-2000',
      73.143528,
      26.624635,
      2.917159,
      11.131031,
      9,
      2,
      NULL,
      NULL,
      0.190738,
      18,
      0.522448,
      1.538792,
      13,
      0.826409,
      1.175795,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-15-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      6.991907,
      2.929481,
      40.363879,
      1.734968,
      ' 8- 6-1983',
      14,
      NULL,
      ' 6- 6-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.594199,
      ' 6-14-1989',
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      25,
      NULL,
      ' 0- 7-1994',
      NULL,
      NULL,
      NULL,
      2.559894,
      17.172738,
      NULL,
      6.460153,
      ' 5- 6-1986',
      9.500923,
      0.083903,
      111,
      ' 2-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


