set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9430524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10043341',
      '10020024',
      '02344424',
      '34130134',
      NULL,
      '31342204',
      '12023133',
      '32200340',
      '33313324',
      '31311211',
      '11304321',
      '02041344',
      '21120413',
      '44320033',
      NULL,
      '12010411',
      '02024132',
      NULL,
      '11132114',
      NULL,
      NULL,
      NULL,
      NULL,
      '13321122',
      '20032104',
      '03142320',
      '24140432',
      '21313420',
      '10010113',
      '42024142',
      NULL,
      '11112343',
      NULL,
      '21103013',
      '41110400',
      '14314134',
      '01214040',
      NULL,
      NULL,
      '42204124',
      '32041332',
      '30210234',
      '00214120',
      '31201101',
      '314',
      '43',
      35.731229,
      15,
      '1212242',
      3,
      41,
      NULL,
      NULL,
      NULL,
      1.949938,
      ' 3- 2-1984',
      '10-19-1975',
      22,
      22,
      0.656003,
      5,
      13,
      NULL,
      89,
      19,
      12,
      14.331508,
      30,
      1,
      21.542675,
      19,
      30,
      20,
      14,
      0,
      NULL,
      31,
      37,
      25,
      39.513434,
      23.509203,
      1.923033,
      38,
      77.941545,
      NULL,
      203,
      NULL,
      NULL,
      ' 6- 8-1993',
      36.574536,
      3.990314,
      11,
      28.154074,
      8.129830,
      32,
      ' 7-27-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      32,
      NULL,
      4.688618,
      1,
      NULL,
      ' 9-15-1986',
      0.843479,
      1.213968,
      103,
      1.019490,
      NULL,
      128,
      0.429906,
      5,
      102,
      NULL,
      NULL,
      NULL,
      ' 7- 5-1979',
      NULL,
      88,
      96,
      112.316502,
      64.519881,
      68,
      44,
      88.580910,
      10,
      0.341143,
      47.481416,
      74.511854,
      NULL,
      20,
      2.013009,
      NULL,
      45.830494,
      49,
      167,
      14,
      NULL,
      20,
      5,
      ' 2- 2-1980',
      NULL,
      7.219300,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      74.493662,
      0.995376,
      9,
      NULL,
      15,
      0.794076,
      7.428211,
      4,
      0.728187,
      ' 7- 0-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      203.898629,
      27.854484,
      ' 8- 4-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-22-2000',
      NULL,
      5,
      ' 2-17-1978',
      11,
      8,
      ' 6- 9-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      25.841909,
      ' 1-26-1994',
      69,
      54.267495,
      NULL,
      ' 4- 6-1981',
      NULL,
      8.324529,
      ' 9- 7-1993',
      15.962314,
      NULL,
      5.087198,
      41.572988,
      ' 3-22-1985',
      44,
      1,
      148.359824,
      ' 8- 4-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


