set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9430524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '3',
      '4',
      '4',
      NULL,
      '0',
      '1',
      NULL,
      '4',
      '2',
      '4',
      '4',
      '0',
      '0',
      '1',
      NULL,
      NULL,
      '3',
      '1',
      '2',
      '2',
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      '3',
      NULL,
      NULL,
      '0',
      '1',
      '1',
      '4',
      NULL,
      '2',
      '0',
      '3',
      '3',
      '2',
      '1',
      NULL,
      '13',
      NULL,
      17,
      NULL,
      NULL,
      6,
      2,
      NULL,
      '024103',
      3,
      ' 8- 6-2002',
      '10-14-2000',
      NULL,
      159,
      34,
      NULL,
      21,
      6.277405,
      19.214570,
      NULL,
      NULL,
      NULL,
      7,
      8.020176,
      22,
      16.707446,
      35.017329,
      19,
      8.600467,
      3.424157,
      81,
      NULL,
      4,
      15.175183,
      48,
      23.555454,
      3.752724,
      82.209117,
      180.746005,
      81,
      106,
      169.190862,
      NULL,
      '11-12-1995',
      5,
      24.125826,
      3,
      31.742564,
      NULL,
      217.001970,
      ' 0-23-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      NULL,
      37.227976,
      2.864108,
      NULL,
      NULL,
      ' 6-21-1988',
      1.325041,
      0.815307,
      258,
      NULL,
      1.840231,
      8,
      NULL,
      0.173815,
      85.019778,
      NULL,
      NULL,
      NULL,
      '10-18-1986',
      50,
      95,
      86.520823,
      45,
      46.341981,
      NULL,
      22.144494,
      66.632213,
      12.532236,
      NULL,
      35.195308,
      24,
      NULL,
      NULL,
      10,
      8.252305,
      35.893456,
      18,
      100.741555,
      NULL,
      NULL,
      2,
      29.808770,
      ' 9- 4-1979',
      6.472037,
      NULL,
      5,
      15,
      20.655063,
      NULL,
      0,
      NULL,
      1.690595,
      93,
      1.845722,
      0,
      NULL,
      NULL,
      2,
      1,
      0.535720,
      0,
      '11-16-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      '11-21-1998',
      NULL,
      NULL,
      NULL,
      52.142542,
      ' 0-23-1994',
      47,
      NULL,
      4,
      12.058580,
      '11-20-1975',
      36.683498,
      33,
      ' 9-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      19.401105,
      ' 9-17-1996',
      46.490924,
      24.938577,
      2,
      NULL,
      1.531293,
      37.450870,
      ' 2-13-1988',
      7,
      17.172253,
      10,
      18,
      ' 5-16-1983',
      64.458299,
      NULL,
      NULL,
      ' 3-15-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


