set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9414576';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3301',
      NULL,
      NULL,
      '12200004',
      '03201310',
      '33040112',
      '02140433',
      '31301201',
      '33243412',
      '00342414',
      '04334140',
      '13400424',
      NULL,
      '02213243',
      '13430332',
      '20411413',
      '24114222',
      NULL,
      '11223404',
      '34224033',
      '41433240',
      '44003032',
      NULL,
      NULL,
      '40243130',
      '32433344',
      '21433014',
      NULL,
      '33032420',
      '04344240',
      '22010134',
      '22112124',
      '22211403',
      '11012000',
      NULL,
      '01302031',
      '12242303',
      NULL,
      '03134310',
      '00224321',
      '30210012',
      NULL,
      '00233102',
      '21310101',
      NULL,
      '120',
      '14',
      NULL,
      NULL,
      '0433030',
      1.634665,
      1,
      NULL,
      NULL,
      '440040',
      NULL,
      NULL,
      ' 3- 8-1989',
      16,
      NULL,
      NULL,
      11.166001,
      6,
      22,
      76,
      1.376733,
      23.777253,
      18,
      30,
      NULL,
      NULL,
      3.032810,
      NULL,
      NULL,
      NULL,
      12,
      47.066582,
      17.533048,
      21.931682,
      0.098232,
      1,
      3.039819,
      0,
      17,
      99,
      26,
      NULL,
      NULL,
      128.302398,
      NULL,
      39.787615,
      20.248114,
      24.003659,
      18.492819,
      78.610722,
      22,
      NULL,
      4.339054,
      5,
      NULL,
      0.930970,
      0.412431,
      1.530206,
      4,
      3.366834,
      0.387446,
      2.505038,
      0,
      0.305935,
      0,
      0.751820,
      1,
      0.329671,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-24-1986',
      11,
      27,
      4,
      1,
      51,
      NULL,
      ' 6-18-1979',
      0.172614,
      0,
      NULL,
      0.787489,
      3.293712,
      91,
      1,
      1.965688,
      20.053914,
      NULL,
      NULL,
      NULL,
      '10- 3-2001',
      10.538602,
      56.164316,
      86,
      73,
      NULL,
      51.286513,
      25.582408,
      7,
      90.714777,
      46,
      61.379127,
      12.017909,
      ' 8-21-1977',
      28,
      16.565996,
      14,
      17,
      12.205802,
      NULL,
      6,
      ' 9-25-1979',
      NULL,
      3.370271,
      ' 7- 8-1975',
      1.305086,
      14,
      NULL,
      10.514586,
      11,
      NULL,
      NULL,
      17.998367,
      1.102878,
      NULL,
      0.912394,
      19,
      6,
      3,
      0,
      1,
      0,
      0,
      ' 0-26-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      93,
      47.023077,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      ' 8- 3-1999',
      37.126463,
      ' 8- 4-1985',
      7.758545,
      7,
      ' 6-29-1982',
      96,
      17.405193,
      NULL,
      1.091532,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      10,
      ' 8- 2-1993',
      15.579454,
      18.325496,
      12,
      ' 6-15-1981',
      NULL,
      NULL,
      ' 1-26-1995',
      13,
      46.127913,
      NULL,
      21,
      NULL,
      30.506904,
      NULL,
      NULL,
      ' 2-23-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


