set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9976000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      '2',
      '3',
      '2',
      NULL,
      '2',
      '3',
      NULL,
      '0',
      '3',
      '4',
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      '4',
      NULL,
      '3',
      '1',
      '',
      NULL,
      NULL,
      '3',
      NULL,
      '3',
      '1',
      '4',
      NULL,
      '',
      '3',
      '2',
      NULL,
      '2',
      NULL,
      '4',
      NULL,
      '0',
      '4',
      '4',
      '3',
      '304',
      '40032044',
      8.729708,
      39,
      '2140414',
      2.738497,
      0,
      3,
      1,
      '400133',
      0,
      ' 3-12-2003',
      NULL,
      295,
      3,
      6,
      8.886896,
      16,
      1,
      12.163908,
      7.372427,
      6.496254,
      3.153159,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      2,
      3.603412,
      NULL,
      40.453152,
      4.948868,
      29,
      6,
      26,
      4.736705,
      0.216095,
      64,
      81,
      6,
      62,
      79.093016,
      NULL,
      ' 6-15-2002',
      23.088875,
      23,
      19.656527,
      10.193116,
      101.917822,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      NULL,
      0,
      22,
      25,
      NULL,
      ' 6-11-1974',
      0,
      NULL,
      NULL,
      0.904548,
      NULL,
      NULL,
      NULL,
      1,
      50,
      NULL,
      NULL,
      NULL,
      ' 0-23-1975',
      86,
      51,
      41.315619,
      71,
      53.691401,
      55,
      NULL,
      NULL,
      51.688399,
      52.582382,
      87.414523,
      NULL,
      ' 7-17-2000',
      15.703477,
      16,
      NULL,
      31,
      13,
      NULL,
      6.779085,
      ' 8- 9-1975',
      12,
      1.295731,
      ' 9-28-1992',
      10,
      NULL,
      16.358031,
      19.781140,
      23.857852,
      5,
      0,
      3.838045,
      NULL,
      47.539927,
      0,
      15.401854,
      6,
      8,
      4,
      9.368413,
      0,
      0,
      ' 7-28-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      '11-19-1981',
      NULL,
      NULL,
      NULL,
      48.944304,
      ' 3-25-1994',
      NULL,
      ' 3- 7-1975',
      8.788236,
      3,
      ' 0-13-1988',
      18,
      65.987799,
      ' 4-23-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 5- 5-1994',
      40.994692,
      8.070658,
      9.847209,
      ' 8-24-1980',
      1,
      73,
      ' 7-15-1976',
      3.823212,
      NULL,
      1,
      19.746757,
      ' 7-16-1977',
      47.337938,
      NULL,
      NULL,
      '10- 2-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


