set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9420968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4321',
      '12424430',
      '32000004',
      NULL,
      '34201420',
      '03411013',
      '13023134',
      '14423300',
      '23404111',
      '23101342',
      '10133102',
      NULL,
      '42113040',
      '32224144',
      '01423421',
      '11410412',
      '24004134',
      NULL,
      '03442343',
      '41131310',
      NULL,
      '22400243',
      '41122134',
      NULL,
      '44431113',
      '01404231',
      NULL,
      '33313133',
      NULL,
      '04224142',
      '33012234',
      '20313121',
      '42000103',
      '32142122',
      '40101304',
      '42441334',
      '22330342',
      '23321420',
      '33131430',
      '03212401',
      NULL,
      '40111023',
      '04332223',
      '02044112',
      '32042414',
      NULL,
      '23',
      NULL,
      NULL,
      '4311321',
      3,
      0.475945,
      0,
      NULL,
      '103043',
      2,
      ' 8-20-1985',
      ' 1- 4-1987',
      104,
      NULL,
      40,
      NULL,
      NULL,
      8,
      57.401327,
      6,
      2.156444,
      7,
      NULL,
      29,
      NULL,
      23.219554,
      NULL,
      NULL,
      1.318039,
      7.674718,
      68,
      14,
      NULL,
      19.714665,
      17.090552,
      1.194411,
      NULL,
      12.361330,
      28.512175,
      NULL,
      88,
      NULL,
      90,
      ' 1- 1-1986',
      NULL,
      NULL,
      23,
      NULL,
      137.731861,
      108,
      NULL,
      NULL,
      2,
      5.424750,
      0.071620,
      0.291915,
      3,
      2,
      0.443039,
      1.934143,
      NULL,
      2.271163,
      0,
      0,
      0.580172,
      0.325085,
      0,
      2.937276,
      1.724745,
      0.467863,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      4.765357,
      12.003565,
      4,
      NULL,
      1.229289,
      1,
      46,
      1.497937,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      NULL,
      ' 5-25-1990',
      44.207634,
      49,
      88,
      NULL,
      NULL,
      84,
      NULL,
      44.482502,
      23,
      37.429845,
      82.261094,
      84,
      ' 2-28-1975',
      NULL,
      14.228231,
      11.359946,
      NULL,
      NULL,
      80,
      6,
      ' 7- 6-1992',
      12.860238,
      26,
      ' 3-14-2002',
      7.178293,
      9.144905,
      NULL,
      10,
      2.977048,
      6,
      2.079839,
      7.037865,
      1.762841,
      11,
      0,
      1,
      19,
      NULL,
      0.651229,
      1.397949,
      1.118464,
      1,
      ' 6- 8-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      56,
      NULL,
      ' 3-21-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.802360,
      NULL,
      12,
      2,
      ' 7-16-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-19-1978',
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      '10- 8-1977',
      62,
      38,
      16,
      ' 5-24-1974',
      NULL,
      48,
      ' 3-22-1985',
      13,
      21,
      NULL,
      4,
      ' 9-21-1989',
      NULL,
      1.580180,
      324,
      '10- 5-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


