set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000796';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '2',
      '3',
      '0',
      NULL,
      '1',
      '2',
      '4',
      '3',
      '0',
      '1',
      '1',
      '2',
      '2',
      '0',
      '1',
      '0',
      '1',
      '2',
      '1',
      '4',
      '2',
      NULL,
      '',
      NULL,
      '',
      '1',
      NULL,
      '3',
      '0',
      '1',
      '',
      NULL,
      '0',
      NULL,
      '0',
      '3',
      '0',
      '2',
      NULL,
      '3',
      '4',
      NULL,
      '4',
      '223',
      '41331402',
      64.221054,
      22.898565,
      NULL,
      3.203728,
      1,
      1,
      NULL,
      NULL,
      NULL,
      ' 3-22-1994',
      NULL,
      26.636578,
      170.877184,
      4,
      3.204421,
      15,
      NULL,
      11,
      9.265668,
      NULL,
      2.717224,
      18,
      9.493252,
      NULL,
      5.908620,
      18,
      8.817822,
      11,
      6.735262,
      36.434736,
      8.083324,
      45,
      6,
      70,
      20.666056,
      0,
      63.399098,
      98.883847,
      62,
      115.559906,
      NULL,
      129.120160,
      '10-27-1985',
      2,
      32,
      23,
      20,
      119,
      166,
      ' 9- 3-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      28.246196,
      5,
      30,
      NULL,
      '11- 4-1975',
      1.643891,
      0,
      NULL,
      1.762457,
      0.500750,
      79,
      2,
      4.422801,
      11.133511,
      NULL,
      NULL,
      NULL,
      '11- 3-1982',
      NULL,
      75.275105,
      44.761822,
      46,
      7.390948,
      41.969500,
      45,
      5,
      27.945095,
      8,
      33.786043,
      4,
      ' 9-24-1988',
      NULL,
      11,
      15,
      24,
      65,
      28.554370,
      8.921757,
      ' 6- 5-1996',
      2,
      4,
      ' 0- 2-1975',
      2,
      9,
      10,
      2,
      10.207769,
      9.231344,
      0,
      NULL,
      0,
      35,
      NULL,
      0.437278,
      14.464414,
      3.074571,
      0.528995,
      1.370813,
      0,
      1.976828,
      '11- 9-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      67.356249,
      80.940410,
      ' 4-27-1979',
      NULL,
      NULL,
      NULL,
      22.711456,
      NULL,
      NULL,
      ' 2- 0-1995',
      3.214064,
      5.206973,
      ' 8- 1-1993',
      45,
      48.604382,
      ' 4-16-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2.909772,
      ' 5-21-1976',
      NULL,
      7,
      2,
      ' 2-22-1992',
      0.944179,
      89,
      ' 0- 4-1995',
      0.406518,
      NULL,
      9,
      40,
      ' 3-10-1978',
      5.438935,
      0,
      28,
      '10- 8-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


