set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000796';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      '1',
      '2',
      '4',
      '2',
      NULL,
      '0',
      NULL,
      '3',
      NULL,
      '4',
      '3',
      '0',
      NULL,
      NULL,
      '3',
      NULL,
      '0',
      '4',
      '1',
      '2',
      '4',
      '',
      '4',
      '',
      '2',
      '1',
      NULL,
      '4',
      '2',
      '',
      '',
      '1',
      '1',
      '0',
      '1',
      '2',
      '1',
      '0',
      '3',
      '0',
      NULL,
      '4',
      '203',
      NULL,
      26.407597,
      4.242694,
      '2143223',
      3,
      NULL,
      NULL,
      0,
      '200344',
      2.175245,
      ' 9-18-1990',
      ' 1- 7-1976',
      NULL,
      169.111316,
      NULL,
      8.370266,
      10,
      13.362037,
      35,
      5.440048,
      NULL,
      5.773603,
      12,
      4,
      15.363646,
      13.439820,
      NULL,
      10,
      12.446109,
      2,
      26,
      NULL,
      39.672821,
      2.686720,
      100.364160,
      9.199031,
      0,
      32,
      NULL,
      71.446833,
      126.849676,
      107.346456,
      50.812012,
      ' 5-13-2000',
      30,
      5,
      5,
      20.514237,
      51,
      140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38.146359,
      3,
      4,
      9.594424,
      7,
      0.791862,
      '10-25-1989',
      NULL,
      NULL,
      84,
      0.995569,
      6,
      64,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-29-1983',
      80.631495,
      78,
      19.375638,
      21,
      0.817432,
      NULL,
      NULL,
      53,
      NULL,
      25,
      7.230504,
      13.301007,
      ' 8-14-1976',
      8.882583,
      3,
      15,
      17.633061,
      29.304188,
      9,
      8.178791,
      ' 5-10-1977',
      16.209880,
      7,
      ' 6-26-1980',
      2.694261,
      NULL,
      9,
      NULL,
      11.466169,
      NULL,
      NULL,
      NULL,
      0.361752,
      22,
      NULL,
      1,
      8.848314,
      NULL,
      0,
      4,
      NULL,
      0.734247,
      '11-15-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      104,
      NULL,
      '10- 1-1989',
      NULL,
      NULL,
      NULL,
      7,
      '11- 4-1980',
      28,
      '10-27-2002',
      14.527580,
      NULL,
      ' 4- 8-1986',
      52,
      NULL,
      ' 5- 9-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      ' 6-17-1998',
      15,
      4,
      4.317511,
      ' 9- 6-1989',
      0.170026,
      NULL,
      ' 9- 2-1980',
      NULL,
      98.142337,
      6,
      54,
      ' 2- 5-1984',
      NULL,
      0.641763,
      NULL,
      ' 4-20-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


