set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1321',
      '33320422',
      '01012104',
      '11314411',
      '30202221',
      NULL,
      '32200400',
      '31421441',
      '31212432',
      '02344130',
      '22030040',
      '14023424',
      NULL,
      '44110132',
      '22401431',
      '00113023',
      '32303444',
      NULL,
      '42114100',
      '21203402',
      '24320320',
      '44002430',
      '04234314',
      '23420210',
      '44244444',
      '04144440',
      '21400141',
      '11040302',
      NULL,
      '21111343',
      '24323243',
      '14221124',
      NULL,
      '22344221',
      '31121340',
      NULL,
      NULL,
      '33032020',
      '11033323',
      '12410042',
      '43144222',
      '21110403',
      '44030313',
      '40423411',
      '40241421',
      NULL,
      '30',
      NULL,
      13,
      '2324412',
      3,
      1.874589,
      1,
      NULL,
      '022431',
      1.189373,
      ' 4-23-1974',
      '10-10-1974',
      99.962734,
      106.819909,
      49,
      9,
      10.915246,
      17,
      NULL,
      8.922019,
      18.907044,
      NULL,
      14.319768,
      17.769875,
      17,
      12.287776,
      0.421575,
      15,
      NULL,
      18,
      11.809488,
      17,
      25,
      21.467832,
      46.781682,
      2.796536,
      NULL,
      6,
      160,
      39.803030,
      NULL,
      41.418969,
      19.716872,
      ' 8-26-2003',
      55.628355,
      50,
      24,
      34,
      62,
      61.873378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84,
      NULL,
      0,
      14.152382,
      NULL,
      0.753239,
      NULL,
      0.242992,
      1,
      NULL,
      0,
      1.481573,
      106.384484,
      0.770570,
      3.440322,
      30.536019,
      NULL,
      NULL,
      NULL,
      ' 8- 9-2003',
      77,
      31.723999,
      NULL,
      16.235379,
      80,
      53,
      100.688919,
      75,
      NULL,
      90,
      42.302513,
      89.811111,
      ' 7-10-2001',
      NULL,
      NULL,
      NULL,
      75,
      26.911256,
      71.874232,
      10,
      ' 6-10-1991',
      14.162479,
      13.309857,
      ' 8-22-1981',
      9.405845,
      NULL,
      15.373454,
      0,
      NULL,
      13,
      1,
      19.330518,
      1,
      4.982751,
      NULL,
      3,
      16.815240,
      16.372445,
      4.952765,
      2.750765,
      0,
      NULL,
      ' 7-15-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      115.023556,
      NULL,
      ' 2-14-1992',
      NULL,
      NULL,
      NULL,
      12.513967,
      '10- 9-1979',
      8,
      ' 9-29-1974',
      0,
      9.048535,
      ' 6-27-1980',
      8.176499,
      89.342696,
      ' 3-19-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      13,
      ' 7-12-1985',
      55.659875,
      8.230217,
      12,
      ' 3-12-1997',
      1.823591,
      49,
      ' 1-22-1982',
      11,
      46.351291,
      9,
      32.359416,
      NULL,
      55.983538,
      0,
      111.142854,
      '10-15-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


