set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '3',
      '0',
      '4',
      '3',
      '4',
      '1',
      '2',
      '3',
      '1',
      '4',
      '4',
      NULL,
      '3',
      NULL,
      '3',
      '0',
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '0',
      '',
      NULL,
      '',
      '0',
      '1',
      NULL,
      '4',
      '0',
      '',
      '',
      NULL,
      '3',
      '3',
      '3',
      '3',
      NULL,
      '1',
      '0',
      '1',
      NULL,
      NULL,
      '341',
      '12',
      NULL,
      28,
      '4102223',
      1,
      28.406661,
      2,
      NULL,
      '431121',
      2,
      ' 5-13-1978',
      NULL,
      6.787565,
      225,
      22.249953,
      NULL,
      NULL,
      18.535068,
      NULL,
      17.818542,
      24,
      3,
      24.631809,
      11.942408,
      39.509412,
      18,
      NULL,
      7,
      8.382131,
      5.271708,
      79,
      21.222843,
      51,
      14,
      64.788672,
      13.380240,
      0,
      NULL,
      72.982918,
      29.089091,
      68.942597,
      31.088692,
      145,
      ' 1-23-1999',
      46,
      1,
      32.840086,
      3.353598,
      NULL,
      NULL,
      ' 5- 6-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      82.206627,
      12,
      5.020639,
      1,
      4,
      NULL,
      ' 0- 7-1993',
      0,
      0.879983,
      53.607580,
      1.468991,
      0,
      31,
      NULL,
      NULL,
      60.923727,
      NULL,
      NULL,
      NULL,
      ' 4-24-1981',
      35,
      NULL,
      88.369254,
      3.190357,
      77.132845,
      92.530539,
      11,
      63,
      20,
      67,
      59.078547,
      45.082082,
      ' 9-23-1991',
      25,
      8,
      NULL,
      2,
      1,
      NULL,
      13,
      ' 9-29-1983',
      25,
      18,
      ' 1-22-1991',
      10,
      NULL,
      16,
      15.782086,
      NULL,
      4,
      0.989372,
      7,
      NULL,
      53,
      1,
      1,
      0,
      19,
      8,
      NULL,
      1,
      0,
      '11-10-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-22-1997',
      NULL,
      NULL,
      NULL,
      18,
      ' 8- 7-1991',
      19,
      ' 2- 2-1997',
      NULL,
      NULL,
      ' 2-22-1978',
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      11.061414,
      NULL,
      NULL,
      17.085803,
      7.825012,
      ' 6- 7-1991',
      1.678289,
      3,
      NULL,
      9.205972,
      12,
      NULL,
      41.390873,
      ' 5-24-1989',
      NULL,
      0.307339,
      121,
      ' 0-11-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


