set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '0',
      '4',
      NULL,
      '0',
      '3',
      '1',
      '4',
      '4',
      '4',
      '0',
      NULL,
      '1',
      '0',
      '2',
      '4',
      NULL,
      NULL,
      '2',
      '4',
      '0',
      '0',
      '3',
      '',
      '2',
      '',
      '3',
      '0',
      NULL,
      NULL,
      '4',
      '',
      '',
      '3',
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      '0',
      '0',
      '3',
      '3',
      '1',
      NULL,
      '30221343',
      46.425432,
      43,
      '3131330',
      0,
      79,
      2,
      NULL,
      '404344',
      2,
      ' 6- 0-1983',
      ' 0-10-1983',
      NULL,
      61.741892,
      12,
      NULL,
      21.133082,
      7,
      NULL,
      NULL,
      16,
      13,
      NULL,
      3.608421,
      42,
      8.285999,
      17,
      16.380618,
      16,
      6.502199,
      NULL,
      4.179062,
      32.602112,
      21,
      5,
      NULL,
      NULL,
      84.237780,
      56,
      48.340587,
      168,
      111.157691,
      2.011455,
      ' 5- 5-1993',
      29,
      3.327067,
      21.092689,
      11.502312,
      69.526139,
      199.778536,
      ' 7- 5-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      NULL,
      2,
      2.800575,
      11.389629,
      3,
      '10-18-1991',
      0.892684,
      NULL,
      110.766671,
      1.668231,
      3.915418,
      NULL,
      3.128020,
      1,
      44,
      NULL,
      NULL,
      NULL,
      NULL,
      64.336422,
      50,
      42,
      78,
      96,
      52,
      NULL,
      84.002923,
      NULL,
      NULL,
      24.118956,
      22,
      ' 7- 5-1982',
      24,
      16.272882,
      3,
      43.425575,
      41.029668,
      28.860654,
      7,
      '11- 2-1996',
      3.752305,
      3.840409,
      ' 1-15-1990',
      9.273201,
      18,
      NULL,
      21.004290,
      13.554398,
      3,
      0,
      NULL,
      1.373582,
      73,
      1,
      2,
      12.606630,
      3.043860,
      2,
      1,
      NULL,
      1,
      ' 6-25-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      140.576562,
      0.587345,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      27.704543,
      ' 1- 0-1994',
      4.275653,
      2,
      ' 7-27-1985',
      NULL,
      5.511754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 2-26-1995',
      41,
      8.689706,
      NULL,
      ' 1-27-1994',
      0,
      92.616932,
      ' 8-21-1989',
      3.215779,
      15.245689,
      4.078745,
      23.749185,
      ' 3-28-1982',
      36,
      NULL,
      13.561912,
      ' 3-21-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


