set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9505926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0304',
      '34423334',
      '14221301',
      '43333212',
      '22311424',
      '41241134',
      '21324030',
      '44313244',
      '22421043',
      '23142231',
      '01343013',
      '21201240',
      '00244223',
      '23003301',
      NULL,
      '20440233',
      '02400314',
      '02444121',
      '22343041',
      '31212230',
      '24002404',
      '40043303',
      '42443332',
      '11111420',
      '12210011',
      NULL,
      '43312130',
      '21113044',
      '13320233',
      '32412004',
      '34244310',
      '12314412',
      '03112444',
      '23310233',
      '30330403',
      NULL,
      NULL,
      '34120002',
      '20430132',
      '14014241',
      '02221320',
      '32004300',
      '00004321',
      '44303243',
      NULL,
      '313',
      '12',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '130332',
      0.958006,
      ' 5-28-1983',
      ' 2-12-1989',
      23.254538,
      NULL,
      38.565405,
      NULL,
      16,
      5,
      98,
      14,
      26.419120,
      19,
      35,
      7.371746,
      34.266861,
      9.347798,
      30,
      NULL,
      NULL,
      9,
      87.929266,
      NULL,
      68,
      18.442650,
      6.748198,
      NULL,
      NULL,
      29,
      146.284412,
      5.483076,
      81,
      8.845538,
      174,
      ' 7-25-1998',
      57,
      52,
      NULL,
      15,
      161,
      192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      8.079832,
      9,
      NULL,
      NULL,
      0.075606,
      NULL,
      173.389625,
      1.389743,
      0.535999,
      66,
      0.201126,
      NULL,
      59.655580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      83,
      39,
      NULL,
      NULL,
      47,
      NULL,
      70,
      56,
      NULL,
      88,
      NULL,
      ' 0- 6-1991',
      15.923728,
      6.424703,
      21,
      54.555316,
      25,
      18,
      11.303852,
      ' 1- 8-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      0,
      ' 2-22-1983',
      NULL,
      NULL,
      NULL,
      19.823006,
      ' 2-22-1986',
      42,
      ' 3-18-1989',
      17.041420,
      11,
      '10-29-1993',
      NULL,
      NULL,
      NULL,
      3.470264,
      2,
      '11-12-1987',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 4-29-1974',
      45.513328,
      36,
      21,
      NULL,
      0,
      8,
      ' 3-26-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


