set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8731046';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1311',
      '23341233',
      '42034130',
      '03321412',
      '24024222',
      NULL,
      '42403102',
      '34321103',
      '24242414',
      NULL,
      '12321040',
      '04444042',
      '31430321',
      '12300004',
      '24033244',
      '21413421',
      '01043043',
      '40311124',
      '00213441',
      NULL,
      '32132122',
      '12311034',
      '21040030',
      '33013101',
      NULL,
      '23404343',
      '04304424',
      '33422440',
      '12330200',
      '02104012',
      NULL,
      '41030014',
      '10021010',
      '33040143',
      NULL,
      '43140132',
      '40240021',
      '43214112',
      '11220422',
      '20213311',
      '23311322',
      NULL,
      NULL,
      '20440201',
      '24424200',
      NULL,
      '',
      NULL,
      NULL,
      '0111220',
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      ' 7-25-1981',
      ' 5-11-1999',
      38,
      NULL,
      NULL,
      10.922016,
      8.552355,
      14.148868,
      26.628664,
      9,
      NULL,
      NULL,
      20,
      NULL,
      16,
      NULL,
      19.605117,
      1.622523,
      2.788235,
      3,
      NULL,
      2.170625,
      10.815530,
      4,
      67,
      11.219588,
      NULL,
      9,
      72.349850,
      44,
      126.959816,
      139.208718,
      NULL,
      ' 8-23-1987',
      44.709680,
      14,
      8,
      24,
      14,
      32,
      NULL,
      3,
      3.231694,
      9.467288,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914946,
      0.590709,
      NULL,
      1.554425,
      1.078174,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 9-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-22-1979',
      NULL,
      57.266534,
      38,
      37.290477,
      87,
      100,
      33,
      56,
      35.956787,
      NULL,
      28.997983,
      41,
      ' 0- 0-1983',
      NULL,
      7,
      1,
      18.035332,
      20.133269,
      1,
      2.251543,
      ' 5-23-1994',
      5.056686,
      9.799761,
      ' 3-12-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.486063,
      17,
      12,
      ' 2-24-1994',
      1.596248,
      81.288155,
      ' 0-15-1987',
      17,
      30,
      7,
      74,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      0.424031,
      36,
      NULL,
      151.527559,
      32.724529,
      59,
      NULL,
      58,
      NULL,
      66.274548,
      1.346036,
      0.561963,
      83,
      1.262618,
      0.893129,
      72.015828,
      4.371264,
      0,
      95.701743,
      8,
      7.834851,
      7,
      94.006305,
      14,
      NULL,
      0,
      60.044996,
      1.056126,
      NULL,
      NULL,
      NULL,
      0.937029,
      1,
      NULL,
      89.441847,
      41,
      NULL,
      16,
      NULL,
      1,
      1,
      NULL,
      1.986487,
      0,
      1,
      8.502988,
      NULL,
      52.877406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      4.587531,
      16,
      1,
      72,
      17.593474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 6-1993',
      '10-29-1979',
      ' 2- 9-1982',
      ' 1-28-1985',
      ' 7- 6-1996',
      ' 8-20-1983',
      NULL,
      NULL);
commit;
end;
/


