set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788050';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '4',
      NULL,
      NULL,
      '2',
      '4',
      '1',
      '0',
      '4',
      NULL,
      '2',
      '0',
      '1',
      '0',
      '1',
      '0',
      '2',
      NULL,
      '3',
      NULL,
      '1',
      '4',
      '2',
      '',
      '1',
      '',
      '1',
      NULL,
      '3',
      '2',
      NULL,
      '',
      '',
      '0',
      '3',
      NULL,
      NULL,
      '2',
      '3',
      '0',
      '4',
      NULL,
      '3',
      '2',
      NULL,
      '40440221',
      65.209978,
      25,
      '0400012',
      1.949336,
      1.373323,
      NULL,
      1,
      NULL,
      0.195837,
      NULL,
      NULL,
      68.808598,
      58,
      30,
      11,
      20,
      9,
      63,
      4.149323,
      5,
      0,
      29,
      8,
      8.367256,
      0,
      24.795174,
      11.611506,
      7.071698,
      NULL,
      46,
      12.033837,
      NULL,
      1,
      119.328632,
      3.642803,
      0.374049,
      47,
      178.699234,
      58,
      177,
      106.023167,
      NULL,
      ' 7-20-1988',
      NULL,
      NULL,
      1.624617,
      11.167930,
      78,
      187.114541,
      ' 6-28-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      28.443258,
      NULL,
      9,
      22.727337,
      NULL,
      ' 6-10-1994',
      1.720910,
      1.729226,
      NULL,
      1.632108,
      0.042219,
      NULL,
      NULL,
      1.128896,
      4,
      NULL,
      NULL,
      NULL,
      ' 8-19-1988',
      118.820613,
      NULL,
      79.197032,
      NULL,
      19,
      71.391012,
      47.044812,
      22.463133,
      61,
      19,
      74,
      29.557447,
      ' 9-18-1999',
      NULL,
      NULL,
      0,
      12,
      11.735424,
      58,
      2,
      '11- 0-1983',
      NULL,
      12,
      NULL,
      6.873400,
      11.066469,
      7.013906,
      0.249846,
      11.949684,
      5.547558,
      1.121380,
      2,
      1,
      108,
      1.152470,
      0.949691,
      NULL,
      10.062702,
      9.109339,
      2,
      4,
      0,
      ' 6- 0-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.199070,
      '10-24-1993',
      NULL,
      NULL,
      NULL,
      45,
      ' 7- 0-1980',
      5,
      NULL,
      6.092273,
      5,
      '10-26-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      31.326279,
      ' 7-22-1995',
      58,
      12,
      9,
      '10-18-1993',
      1,
      85,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


