set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7214879';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0011',
      '24400313',
      '31244033',
      '40103210',
      NULL,
      '12210231',
      '33423242',
      '00443210',
      '33441340',
      '41321143',
      '00043410',
      '22422110',
      '24330433',
      '30232132',
      '24302244',
      '24442412',
      '22122303',
      '24332021',
      NULL,
      '04114442',
      '13030401',
      NULL,
      '30112011',
      '10031114',
      '12423400',
      '33121400',
      NULL,
      '12340014',
      '21111040',
      '10334103',
      '32020004',
      NULL,
      NULL,
      '12122000',
      NULL,
      '44222230',
      '31140243',
      '43422232',
      '41432110',
      '43000014',
      '43300001',
      '31404041',
      '03342241',
      '43111124',
      '30322343',
      '100',
      '33',
      1.575947,
      NULL,
      '1122141',
      2,
      0.660428,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      41.590926,
      33.443815,
      4.577898,
      20,
      3,
      63.624986,
      12.022961,
      15.538079,
      10,
      3.696863,
      14,
      27.732995,
      4,
      0,
      NULL,
      19.221007,
      10.624914,
      8.783631,
      0,
      33,
      0,
      85.225262,
      9,
      1.309187,
      96,
      164.693651,
      36,
      64.997346,
      39,
      76.765654,
      ' 1-13-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557815,
      4.017431,
      124,
      NULL,
      2.030914,
      115,
      3,
      1,
      46,
      NULL,
      NULL,
      NULL,
      ' 2- 5-1998',
      79.447379,
      76,
      84,
      NULL,
      52.208562,
      90.476280,
      41,
      75.334192,
      NULL,
      40.914027,
      13,
      7,
      NULL,
      15.383082,
      32.296472,
      19.652109,
      39,
      65.319656,
      109.455202,
      6.815631,
      ' 7-13-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.674740,
      19,
      10,
      NULL,
      NULL,
      19.972455,
      0.889421,
      9,
      NULL,
      NULL,
      1,
      12.283753,
      NULL,
      0.548701,
      1.553656,
      0,
      ' 7- 3-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.002938,
      '10-24-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.700863,
      ' 2- 8-1997',
      62.935903,
      NULL,
      9.241245,
      ' 0-22-1986',
      0.818483,
      55,
      '10-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


