set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9237179';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1131',
      NULL,
      '33424033',
      '00443112',
      NULL,
      '44434114',
      NULL,
      '30243234',
      '40240400',
      '12400431',
      '12402233',
      NULL,
      '42243331',
      '31131022',
      '42114322',
      '12004123',
      '22312242',
      '01433012',
      '24211201',
      NULL,
      '41330410',
      '42444200',
      '43344124',
      '30020134',
      '40210312',
      '23003242',
      '01200330',
      '04442440',
      '21111433',
      '31032120',
      '10344110',
      '21323212',
      '21314012',
      '03002411',
      '12111044',
      NULL,
      NULL,
      '04222004',
      '32000343',
      '42443003',
      NULL,
      '34013140',
      '31213241',
      NULL,
      '44120122',
      '042',
      '32',
      NULL,
      NULL,
      '4404044',
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.325941,
      ' 5- 1-1976',
      ' 5-20-1992',
      NULL,
      NULL,
      NULL,
      11,
      12,
      16.323417,
      NULL,
      6,
      4.623763,
      4.132794,
      NULL,
      7,
      31.264197,
      18.255706,
      4.971531,
      7.158929,
      9,
      10,
      NULL,
      1.021636,
      42,
      1.165698,
      23.017762,
      NULL,
      1.602822,
      43,
      NULL,
      1.351108,
      NULL,
      22,
      NULL,
      '11- 2-1994',
      14.472934,
      8,
      0.844276,
      5.430489,
      69,
      86,
      ' 2-15-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.940027,
      105.510894,
      1,
      NULL,
      0,
      0.382134,
      4.249075,
      49.689653,
      0.892206,
      NULL,
      141,
      ' 9- 0-1978',
      79,
      58,
      87,
      NULL,
      32.319173,
      28.445105,
      1.619405,
      10,
      57,
      31.109698,
      37,
      NULL,
      NULL,
      3.227986,
      24.339963,
      18.901386,
      46.668492,
      20.030050,
      21.937219,
      1.598021,
      ' 2-22-1978',
      3,
      4.690329,
      ' 5- 1-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057197,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.868400,
      ' 0- 1-1984',
      7.932759,
      ' 0-27-1985',
      10,
      NULL,
      ' 4-12-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      51.328671,
      7.238943,
      17,
      '11-18-1980',
      NULL,
      NULL,
      NULL,
      4.594758,
      NULL,
      9.771275,
      54,
      ' 3- 7-2001',
      53,
      0.948408,
      36.200780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7);
commit;
end;
/


