set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8303508';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4311',
      NULL,
      '00113032',
      '33130122',
      '20113312',
      '11302420',
      '42313230',
      '44341422',
      '14232000',
      '12001111',
      '12422131',
      '00042233',
      NULL,
      '23300321',
      NULL,
      '40332242',
      '24332021',
      '11341014',
      '40401102',
      '24330312',
      '22013142',
      '33210401',
      '03241121',
      '34002213',
      '20422432',
      '23414420',
      NULL,
      '41111120',
      '24001113',
      '03014130',
      NULL,
      NULL,
      '13100310',
      '10224343',
      '10210101',
      '31003232',
      '21101414',
      '34440000',
      '01202034',
      NULL,
      '44320023',
      '30443242',
      '02314021',
      '43331140',
      '01321133',
      '',
      '',
      NULL,
      NULL,
      '2112010',
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      ' 0-20-1980',
      ' 9- 2-1979',
      NULL,
      NULL,
      6.085008,
      6.982660,
      NULL,
      6.203534,
      79.092313,
      5.241428,
      4,
      19.681801,
      22,
      NULL,
      NULL,
      1.911457,
      27.667298,
      NULL,
      14,
      NULL,
      36,
      7.442847,
      72.783289,
      6.064825,
      108,
      3,
      NULL,
      5.433263,
      178,
      66.767292,
      NULL,
      201.410583,
      27,
      ' 9-23-1991',
      46,
      76.324312,
      29,
      17.678371,
      158.956919,
      66,
      ' 5-24-1992',
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061601,
      1.966168,
      1,
      1.966142,
      1.412277,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-12-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-10-1983',
      NULL,
      92,
      NULL,
      108.627244,
      51,
      NULL,
      22.569256,
      NULL,
      NULL,
      90.175551,
      5.148604,
      112.230170,
      '11- 1-1979',
      17,
      8.512526,
      NULL,
      17.648879,
      17.687880,
      NULL,
      1,
      ' 1-10-1984',
      NULL,
      17,
      ' 0-17-1974',
      8,
      6.132965,
      9.717661,
      12,
      NULL,
      5,
      NULL,
      10.325263,
      NULL,
      57.259835,
      1,
      3.008738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 9-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.112394,
      31.834088,
      ' 1- 2-1991',
      0.920946,
      117,
      ' 6-22-1995',
      8,
      6.850926,
      15.053165,
      0.460019,
      ' 4- 5-1995',
      39.106408,
      0,
      NULL,
      ' 0- 8-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      20.111690,
      1.094709,
      NULL,
      NULL,
      39,
      NULL,
      7,
      1,
      7,
      NULL,
      NULL,
      1,
      0,
      71.747166,
      0,
      0,
      49.095262,
      NULL,
      0,
      92,
      2.828801,
      4.408859,
      30.796417,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      0.552850,
      0.536747,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.587690,
      NULL,
      1,
      1,
      2,
      56,
      0,
      NULL,
      0,
      NULL,
      0.514746,
      NULL,
      NULL,
      25.364908,
      12,
      35,
      NULL,
      NULL,
      25,
      NULL,
      6.967264,
      NULL,
      0.663111,
      1.858537,
      NULL,
      1.554787,
      1.014824,
      0.518801,
      NULL,
      ' 3- 7-1998',
      '10-14-1993',
      ' 0-24-1997',
      ' 0-18-1976',
      NULL,
      NULL,
      ' 2-16-1988',
      NULL);
commit;
end;
/


