set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507588';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2321',
      '24000223',
      NULL,
      NULL,
      '41321433',
      '21000300',
      NULL,
      '04322034',
      '32310442',
      NULL,
      '31300131',
      '42132212',
      '10104134',
      '41002441',
      '41112400',
      '34430030',
      NULL,
      '23302002',
      '14004102',
      '14330040',
      '21123423',
      '14213440',
      '03011134',
      '24411432',
      '04321411',
      '40414043',
      '41040104',
      '21122003',
      '04022031',
      '34222023',
      '41141240',
      NULL,
      '43042434',
      '34413210',
      '20240114',
      '44143100',
      NULL,
      NULL,
      '13032224',
      '31114024',
      '42031234',
      '01423441',
      '21124430',
      '43300323',
      '02411413',
      '230',
      '21',
      NULL,
      NULL,
      '1124242',
      2,
      NULL,
      1,
      NULL,
      '200042',
      NULL,
      NULL,
      NULL,
      98,
      NULL,
      23.079702,
      19.128088,
      11.602323,
      0,
      NULL,
      11.074411,
      28,
      0,
      NULL,
      17.046205,
      0,
      28.638625,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      12,
      45.098171,
      NULL,
      2,
      18,
      NULL,
      NULL,
      149,
      11,
      21,
      89,
      85.707060,
      ' 0- 9-1978',
      8,
      26.526301,
      6.379325,
      10.004523,
      NULL,
      186.450527,
      ' 6-22-1995',
      1,
      3,
      2,
      4,
      6,
      3.145994,
      3,
      3,
      1,
      0.345893,
      1,
      0.163037,
      NULL,
      NULL,
      NULL,
      0.431645,
      3.553389,
      1,
      1.994197,
      3.329505,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-16-1993',
      NULL,
      17,
      NULL,
      3,
      6,
      8.649052,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      50.055103,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 8-2002',
      12.533191,
      49,
      86,
      28.071459,
      70,
      23.009647,
      NULL,
      34.082226,
      44,
      14.363202,
      44.994335,
      19.562912,
      ' 2-21-2000',
      9.447510,
      2.988238,
      10.448842,
      35.310135,
      35.738878,
      151,
      4,
      ' 0- 7-1991',
      18,
      13,
      ' 9- 1-1979',
      12.701793,
      NULL,
      4.976412,
      10.059164,
      14.865753,
      0,
      1.401564,
      3.462078,
      0,
      44.974123,
      0,
      5.542509,
      1,
      15,
      6.075862,
      7,
      7,
      1,
      ' 3- 2-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      3.580237,
      ' 8-17-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      '10-25-1985',
      NULL,
      NULL,
      '11- 3-2000',
      96,
      27.934301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      ' 3-15-2002',
      45.977109,
      0,
      NULL,
      ' 8-29-1986',
      0,
      63.702193,
      ' 0- 4-1994',
      8,
      4.535959,
      18,
      15.557034,
      ' 2-10-1992',
      69.526797,
      1.597884,
      127.913718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


