set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1141',
      '24120123',
      '13413214',
      '30313110',
      '00340042',
      '13024321',
      '30143444',
      '44121010',
      NULL,
      '20120213',
      '10304210',
      NULL,
      '10030341',
      NULL,
      '12231001',
      '24430214',
      '02110300',
      '23323110',
      '02334410',
      '04432023',
      NULL,
      NULL,
      '42210421',
      NULL,
      '43121223',
      '11114041',
      '30312330',
      NULL,
      NULL,
      '30122200',
      NULL,
      '12010214',
      NULL,
      '02334142',
      '23430100',
      '00034414',
      '10314404',
      '23103304',
      '40322340',
      NULL,
      '33231424',
      '34034232',
      '22241140',
      '42304401',
      '01342210',
      '',
      NULL,
      NULL,
      NULL,
      '1244312',
      2.799690,
      NULL,
      NULL,
      NULL,
      '000343',
      3.713015,
      ' 5-19-1996',
      '11-14-1985',
      41.104831,
      NULL,
      9,
      8.069644,
      6,
      16.890515,
      6.583142,
      9,
      3.857580,
      9.988476,
      NULL,
      NULL,
      NULL,
      4,
      13,
      NULL,
      10,
      NULL,
      5.612445,
      8,
      4,
      4.462959,
      32.643454,
      6.003577,
      NULL,
      65,
      154,
      2,
      83,
      125.135182,
      NULL,
      ' 9-11-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-25-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.672519,
      NULL,
      39,
      NULL,
      NULL,
      0.049762,
      NULL,
      NULL,
      NULL,
      ' 3- 0-2001',
      4,
      12.779714,
      6,
      7,
      23,
      6.940069,
      NULL,
      5,
      NULL,
      0.810336,
      2.147186,
      2,
      1.796419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.759998,
      11.663770,
      20.454844,
      NULL,
      0,
      NULL,
      ' 5-12-1983',
      8,
      17,
      12.608773,
      7.674770,
      ' 4- 3-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.094005,
      NULL,
      2.707741,
      NULL,
      38.160114,
      72,
      NULL,
      NULL,
      NULL,
      2,
      108,
      1,
      1.072111,
      NULL,
      0,
      2,
      NULL,
      5.517510,
      NULL,
      42,
      110,
      NULL,
      NULL,
      1,
      113.537545,
      1,
      0.442743,
      NULL,
      NULL,
      0.086156,
      0,
      106,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      97,
      0,
      3,
      2.636464,
      18,
      0.513337,
      10,
      117.184440,
      25,
      NULL,
      NULL,
      2,
      7,
      12.084264,
      0,
      1.134016,
      1,
      1.338766,
      NULL,
      110,
      ' 8-19-1998',
      NULL,
      NULL,
      NULL,
      ' 3-21-1976',
      NULL,
      ' 1-24-1991',
      NULL);
commit;
end;
/


