set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4404',
      '22400441',
      '14142100',
      '01414424',
      '40210442',
      '20310442',
      '40013101',
      '02221142',
      '02343343',
      NULL,
      '03220341',
      '00012313',
      '44421023',
      '13234021',
      '00422402',
      '11440302',
      '23443240',
      '01002343',
      '13141221',
      '11034332',
      '04312100',
      '12022432',
      '04422000',
      NULL,
      '43004302',
      '41030422',
      '01320440',
      NULL,
      '14440302',
      NULL,
      '24043200',
      '44021140',
      '13124242',
      '32022443',
      NULL,
      '23304403',
      NULL,
      '33110201',
      '02322243',
      '21024044',
      '21333200',
      '32000030',
      '12220424',
      '43132404',
      NULL,
      NULL,
      '44',
      NULL,
      23,
      NULL,
      0.866470,
      NULL,
      NULL,
      NULL,
      '121231',
      5.098194,
      ' 3-20-1976',
      ' 3- 7-2002',
      64,
      125.959350,
      26.337731,
      NULL,
      19.198407,
      2.161084,
      67.079892,
      NULL,
      8,
      9.028779,
      23.540475,
      4,
      10.003674,
      NULL,
      2.381018,
      6,
      NULL,
      NULL,
      8.202480,
      2,
      NULL,
      10,
      51,
      NULL,
      0.317800,
      41.367180,
      31.529912,
      2.090382,
      91.811552,
      20,
      135.285088,
      ' 6- 7-1999',
      NULL,
      27.735879,
      7,
      2,
      NULL,
      15,
      ' 9- 6-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.002913,
      44,
      NULL,
      16,
      19.206435,
      5,
      ' 3-15-1975',
      NULL,
      1.431646,
      133,
      0.161154,
      NULL,
      20.490404,
      1.183391,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      ' 7-13-1976',
      NULL,
      76.870147,
      0.487679,
      55,
      NULL,
      70,
      NULL,
      56.052434,
      31.523867,
      52,
      5,
      NULL,
      ' 5-15-1995',
      0.415817,
      22.651615,
      5,
      38,
      41,
      3,
      1.584394,
      '11-27-1999',
      14.762648,
      18.550451,
      ' 8- 1-1981',
      6.745810,
      5,
      4.233221,
      NULL,
      NULL,
      NULL,
      1.624305,
      14,
      NULL,
      19,
      NULL,
      7.193206,
      0.324201,
      NULL,
      5.191943,
      NULL,
      0.738054,
      0,
      '11- 1-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      19.397094,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      ' 4-26-2003',
      34.188877,
      NULL,
      10.554831,
      8,
      NULL,
      78.225971,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.768107,
      NULL,
      13,
      NULL,
      0.026316,
      ' 9-20-1995',
      NULL,
      133,
      ' 5-19-1978',
      NULL,
      15,
      4.218782,
      16.623251,
      NULL,
      66,
      NULL,
      184.992488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


