set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '3',
      '3',
      '3',
      NULL,
      '1',
      NULL,
      '0',
      NULL,
      '1',
      '3',
      '1',
      '3',
      '0',
      '1',
      '0',
      '1',
      '2',
      '2',
      '2',
      '4',
      '1',
      '3',
      '',
      NULL,
      '',
      '2',
      '3',
      '4',
      '4',
      '3',
      NULL,
      '',
      NULL,
      '2',
      NULL,
      '0',
      '0',
      '3',
      '3',
      '0',
      '1',
      '1',
      '0',
      '103',
      NULL,
      31.244610,
      9.418342,
      '3344122',
      0,
      NULL,
      0,
      NULL,
      '020440',
      NULL,
      ' 1-20-1987',
      ' 0-11-1987',
      NULL,
      NULL,
      22,
      14,
      24,
      NULL,
      17.183023,
      0.070864,
      7.736264,
      0,
      2,
      NULL,
      21,
      2.672520,
      23,
      5,
      1,
      5,
      25.880504,
      6,
      29.871114,
      6,
      27,
      0.988473,
      0,
      23,
      101,
      NULL,
      NULL,
      53.629573,
      119,
      ' 6- 5-1980',
      31,
      15.113019,
      NULL,
      7.797752,
      152,
      NULL,
      ' 4- 1-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      1,
      8.130991,
      1.606705,
      NULL,
      ' 5-10-1988',
      NULL,
      0.738506,
      141,
      1,
      0,
      176,
      2,
      2.229872,
      16,
      NULL,
      NULL,
      NULL,
      ' 6-29-2000',
      75,
      NULL,
      1.998471,
      80,
      98.857363,
      4.108102,
      76.923175,
      NULL,
      NULL,
      38.058869,
      32,
      53.133076,
      ' 2- 8-1978',
      NULL,
      5.894605,
      2.617415,
      14.721832,
      NULL,
      3,
      2.180212,
      ' 9-10-1977',
      9,
      1.142299,
      '10- 3-2003',
      NULL,
      1.076661,
      1.137273,
      0,
      NULL,
      1,
      NULL,
      18,
      1.695716,
      37.451026,
      1.585070,
      NULL,
      6.010780,
      NULL,
      1,
      NULL,
      1.970203,
      0.973093,
      ' 6-20-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      30.032599,
      16,
      ' 6-14-1996',
      NULL,
      NULL,
      NULL,
      43,
      ' 0- 3-2000',
      22,
      NULL,
      8,
      9,
      ' 6- 6-1990',
      13,
      113,
      ' 9- 5-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      10.879200,
      ' 0- 6-1999',
      1,
      0.143074,
      11.906815,
      ' 9-14-1989',
      0.345595,
      128,
      ' 8-15-1986',
      3.517789,
      39,
      4,
      92,
      NULL,
      18.360614,
      1,
      100.497636,
      '11- 7-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


