set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034149';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0041',
      '00014334',
      '01113143',
      '43021332',
      '43433421',
      '14211224',
      '14343100',
      '42020232',
      NULL,
      '10213042',
      '02201212',
      '00304340',
      '11220431',
      '12443341',
      '11440134',
      '44022403',
      '20333403',
      '44211343',
      NULL,
      '03201134',
      '21224432',
      NULL,
      '23331240',
      NULL,
      '23323013',
      '22012410',
      NULL,
      '11040213',
      '04023104',
      '20321413',
      '40234314',
      NULL,
      NULL,
      '00201333',
      '02001431',
      '14134423',
      '20100004',
      '12414214',
      '42320401',
      '42010421',
      '12042011',
      '32223334',
      '34304003',
      '10214441',
      '40341331',
      '020',
      NULL,
      NULL,
      NULL,
      '3010204',
      3.411271,
      1.692101,
      2,
      NULL,
      '233342',
      0.860243,
      ' 3- 8-1976',
      ' 1-10-1988',
      17,
      NULL,
      30.337092,
      NULL,
      NULL,
      11,
      80,
      21,
      NULL,
      17.936296,
      36,
      8.010529,
      41,
      16.652298,
      35.425746,
      5,
      19.275380,
      5,
      21,
      NULL,
      37.996182,
      6,
      NULL,
      NULL,
      0,
      NULL,
      57,
      14.607933,
      24,
      53.133153,
      185,
      ' 3-23-1998',
      39,
      3.966698,
      19.168310,
      32,
      6,
      193.922535,
      ' 7- 4-1985',
      0,
      1,
      NULL,
      NULL,
      1,
      1.619941,
      1,
      NULL,
      0.533296,
      NULL,
      2.346118,
      0.516550,
      NULL,
      5,
      0.528505,
      1.539330,
      0,
      1,
      0,
      1.954570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      22,
      NULL,
      8,
      9.071043,
      0,
      NULL,
      1.669650,
      1.762907,
      185.526134,
      NULL,
      0,
      32,
      NULL,
      1.455038,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-26-1974',
      NULL,
      120.680617,
      NULL,
      NULL,
      NULL,
      102,
      109.750744,
      94,
      19,
      57,
      NULL,
      NULL,
      ' 0-28-1978',
      15.467720,
      NULL,
      3.779940,
      9.973543,
      47,
      26,
      6,
      ' 3- 8-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.459705,
      2,
      3,
      ' 7- 6-2002',
      37,
      0,
      ' 1-22-1988',
      29.209088,
      2,
      '10-15-1987',
      0,
      ' 8-29-1975',
      40,
      ' 5-15-1979',
      14,
      4,
      '10-14-1983',
      91,
      28,
      NULL,
      3.725446,
      4.401901,
      '10- 7-1986',
      NULL,
      NULL,
      NULL,
      0,
      3,
      12.562276,
      '11-26-2002',
      42.483814,
      23,
      24,
      ' 5-11-1986',
      1,
      27.106519,
      '11-19-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


