set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0114',
      '10212230',
      NULL,
      '43440204',
      '03023443',
      '20322431',
      NULL,
      '04012402',
      '30430231',
      '00312200',
      '02222202',
      '10220130',
      '43311044',
      '04302422',
      '23111200',
      NULL,
      '23102301',
      '21214344',
      '33242441',
      '12441232',
      '31030224',
      '03322321',
      '14442103',
      '24013442',
      '12440322',
      '34414413',
      NULL,
      '20200201',
      '32103100',
      '33322430',
      '33012010',
      '13302140',
      '32334010',
      '22420411',
      '34104333',
      NULL,
      NULL,
      '02014301',
      NULL,
      '01304014',
      '04432324',
      NULL,
      '24311214',
      '30342142',
      '31040200',
      '233',
      '41',
      NULL,
      NULL,
      '4303012',
      NULL,
      0,
      NULL,
      NULL,
      '111241',
      5.515048,
      ' 9-12-1998',
      ' 5-24-1995',
      79.092932,
      NULL,
      7.131350,
      13.225406,
      3,
      9.508324,
      2,
      5,
      10,
      18,
      29,
      18.251035,
      10.624491,
      6.399839,
      18,
      NULL,
      4,
      1.260043,
      NULL,
      1,
      21,
      6.460956,
      71,
      3.316148,
      1,
      17,
      NULL,
      55,
      NULL,
      34.152246,
      49,
      '10-14-1993',
      14,
      53.057250,
      NULL,
      NULL,
      15,
      NULL,
      ' 8-29-1982',
      0,
      0,
      0.530163,
      1,
      NULL,
      2.649289,
      3.817352,
      1,
      0.084587,
      0,
      1.888258,
      1,
      NULL,
      2,
      0,
      3.919744,
      0.653659,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-11-1986',
      76.082405,
      23,
      NULL,
      0,
      5,
      0,
      ' 7-23-1976',
      3,
      NULL,
      74.730748,
      2,
      0,
      119,
      1.370028,
      1.710977,
      44.657374,
      NULL,
      NULL,
      NULL,
      ' 3- 6-1992',
      NULL,
      14,
      NULL,
      70.186962,
      61,
      22,
      NULL,
      31,
      87.766247,
      43,
      50.785215,
      NULL,
      ' 7-14-1975',
      11.802948,
      9.073147,
      8.158599,
      10,
      29,
      1.673801,
      1.745649,
      '11-25-1978',
      4,
      0,
      ' 5- 6-1983',
      2.357734,
      1.842823,
      4.787426,
      NULL,
      3.616122,
      5.199533,
      NULL,
      5.169844,
      0.651778,
      NULL,
      5,
      2,
      10,
      17,
      1.893687,
      0,
      0.604802,
      1,
      '11-24-2002',
      1,
      1.738973,
      0,
      NULL,
      100.069038,
      18,
      ' 5- 0-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.222175,
      '11-28-2002',
      NULL,
      14,
      NULL,
      92,
      NULL,
      '10-18-1988',
      3,
      NULL,
      ' 8- 0-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.588811,
      NULL,
      5.919525,
      10,
      17.137624,
      '11- 6-1991',
      NULL,
      12,
      '10- 7-1989',
      9.600640,
      54,
      0,
      5.286567,
      '11- 5-1977',
      NULL,
      1.390791,
      50,
      ' 1-10-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


