set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22011044',
      '23402434',
      '01031012',
      '43130223',
      '33422243',
      '03033013',
      '31441440',
      '32323331',
      NULL,
      '33132420',
      '13124221',
      '14122312',
      '04210212',
      '41020002',
      '11033221',
      '41422300',
      '40134143',
      '10132041',
      '40444130',
      '00331211',
      '10114244',
      '12330342',
      '21414013',
      NULL,
      '11133114',
      '12311010',
      '00041040',
      '40034032',
      '00201042',
      NULL,
      NULL,
      '30141421',
      '21440232',
      NULL,
      NULL,
      NULL,
      '44324120',
      '34400300',
      '24324443',
      '21212212',
      '44203221',
      '40210013',
      '24220002',
      '02423442',
      '332',
      NULL,
      NULL,
      NULL,
      '4031113',
      NULL,
      11,
      2,
      NULL,
      NULL,
      NULL,
      '10-15-1975',
      ' 9-15-2001',
      NULL,
      NULL,
      21,
      3,
      14.597641,
      0,
      101,
      7.893135,
      2.886638,
      5,
      36,
      22,
      10.841545,
      12.542480,
      34,
      15,
      29,
      16.880403,
      44,
      24,
      60,
      10,
      17.212073,
      6,
      0.143585,
      10.454597,
      201,
      48.579722,
      177.072054,
      182,
      116,
      ' 6- 0-1983',
      3,
      61.382810,
      3,
      22,
      NULL,
      48.024854,
      ' 5-27-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      NULL,
      5.061860,
      NULL,
      9,
      ' 4-22-1982',
      0,
      4,
      155,
      0.996160,
      NULL,
      NULL,
      0.907701,
      1.550898,
      37,
      NULL,
      NULL,
      NULL,
      ' 8-13-1976',
      33.527730,
      25,
      39.933722,
      27,
      27,
      NULL,
      NULL,
      26,
      NULL,
      76,
      NULL,
      47.059476,
      ' 0-10-1981',
      3.849100,
      5,
      NULL,
      17.156637,
      65.350225,
      43,
      0,
      ' 4-25-1993',
      24.246520,
      NULL,
      ' 0- 1-1998',
      7,
      NULL,
      14.458897,
      19,
      2.328645,
      2.120364,
      1.948110,
      NULL,
      1.849909,
      45,
      0,
      8.701985,
      12,
      16,
      NULL,
      0,
      NULL,
      2,
      ' 7-18-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      191.704812,
      11,
      ' 9-29-1981',
      NULL,
      NULL,
      NULL,
      4,
      ' 3- 1-1994',
      38,
      ' 3-20-2000',
      14,
      8,
      ' 9-23-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-11-1983',
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      ' 3-29-1987',
      NULL,
      20.840325,
      18,
      ' 5-29-1978',
      1.588228,
      100.400196,
      ' 4-21-1992',
      2,
      10.823778,
      NULL,
      15,
      ' 9-18-1998',
      NULL,
      0,
      NULL,
      ' 9- 8-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


