set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1122',
      '44332022',
      '12330322',
      '14102222',
      '02001233',
      '34141043',
      NULL,
      '13143122',
      '04210134',
      '31423401',
      '04433301',
      '33410304',
      '44211114',
      '44023400',
      '44333400',
      '00210333',
      '00122324',
      '24012240',
      '44301110',
      NULL,
      '44403412',
      '00440030',
      '03020233',
      '03242214',
      '40144120',
      '12334113',
      NULL,
      '23323023',
      '43040420',
      '13044103',
      '21402121',
      '40212320',
      '14424211',
      '31124411',
      '12333440',
      NULL,
      NULL,
      '41203013',
      '44112434',
      '33232030',
      '44011400',
      NULL,
      '03103211',
      NULL,
      '11203240',
      '312',
      '24',
      NULL,
      7,
      '0101010',
      NULL,
      NULL,
      2,
      NULL,
      '214131',
      5.391036,
      ' 5- 6-1991',
      ' 0-21-1980',
      NULL,
      94,
      37.000080,
      6,
      27.211688,
      19,
      45.385986,
      18.204225,
      29.374670,
      NULL,
      0,
      14,
      0,
      14,
      2,
      19.419903,
      34.279075,
      12.950399,
      57,
      19,
      NULL,
      NULL,
      17,
      10.534036,
      0,
      NULL,
      NULL,
      39,
      NULL,
      8.983901,
      113,
      NULL,
      36.398338,
      16.629194,
      24,
      29.029657,
      117.503569,
      86,
      ' 2-26-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63.114495,
      13,
      6,
      NULL,
      2.318749,
      11,
      ' 6-11-2001',
      0.927184,
      0,
      161,
      1.427830,
      2,
      NULL,
      NULL,
      1.662838,
      70.813286,
      NULL,
      NULL,
      NULL,
      ' 1-18-1996',
      41,
      NULL,
      NULL,
      56,
      117,
      115,
      24.337537,
      NULL,
      99,
      77.430168,
      95,
      68,
      '10-13-1986',
      17.489082,
      2.279392,
      13,
      31.166628,
      48,
      7.536407,
      3.213745,
      ' 2- 9-1982',
      0,
      0.283122,
      '10- 6-1999',
      9.878705,
      2,
      12.944213,
      11.248171,
      1,
      7.266061,
      1.768459,
      12,
      1,
      NULL,
      0.985723,
      NULL,
      14.947308,
      12.572903,
      1,
      0,
      1,
      1,
      ' 6-12-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      81,
      5.642680,
      ' 9-29-1978',
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      12.871270,
      NULL,
      2.275002,
      NULL,
      ' 4-13-1977',
      93.970380,
      106,
      ' 9-23-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      ' 0-14-1982',
      55,
      4,
      39.561853,
      ' 2- 4-1987',
      0.736661,
      65.710892,
      ' 2-20-1989',
      10.121994,
      7.344574,
      21.290879,
      2,
      '10- 8-1982',
      62,
      0.982973,
      257.766854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


