set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '4',
      '3',
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '3',
      '1',
      '0',
      '0',
      '2',
      '4',
      '4',
      '2',
      '3',
      NULL,
      NULL,
      '',
      '4',
      '4',
      '2',
      '0',
      '3',
      '',
      '',
      '2',
      '4',
      '3',
      '3',
      '1',
      '3',
      '1',
      '3',
      '1',
      NULL,
      '4',
      '044',
      NULL,
      58,
      73,
      '2332240',
      1,
      73,
      NULL,
      0,
      '331130',
      3.087140,
      ' 4-13-1995',
      ' 0- 7-1994',
      200,
      82,
      NULL,
      4,
      16.734102,
      21.468994,
      54.395497,
      NULL,
      29.140043,
      19.097201,
      21.952285,
      NULL,
      13.372705,
      8.479814,
      3,
      22,
      0.264603,
      8,
      34.106282,
      4.311542,
      18,
      15.937493,
      0.683799,
      9,
      0.602736,
      NULL,
      5,
      49,
      NULL,
      36,
      NULL,
      ' 0- 2-1983',
      38.108162,
      55.317682,
      28.998669,
      NULL,
      193,
      64.031051,
      ' 4-24-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77.525650,
      12,
      7,
      NULL,
      1.522643,
      5.967279,
      ' 9-11-1982',
      1.574455,
      1,
      NULL,
      NULL,
      0,
      70,
      0,
      0.098219,
      61,
      NULL,
      NULL,
      NULL,
      ' 4-11-1998',
      10,
      NULL,
      57.511827,
      49,
      7.593278,
      NULL,
      104,
      18.912225,
      23.635508,
      NULL,
      94.791408,
      53,
      ' 5- 1-1984',
      2,
      NULL,
      9.002101,
      6.140078,
      15,
      6.972777,
      4,
      ' 8-14-1975',
      3.487481,
      10.082357,
      NULL,
      NULL,
      9,
      10,
      0.064447,
      0.172848,
      6.276492,
      NULL,
      11,
      1,
      46.426286,
      NULL,
      6.672801,
      5.532898,
      13.585018,
      5,
      2,
      1,
      0,
      ' 2-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      118.761050,
      7,
      ' 9- 3-1974',
      NULL,
      NULL,
      NULL,
      46.971036,
      ' 2-12-1996',
      29.117163,
      NULL,
      15,
      13.016168,
      ' 0-18-1980',
      6,
      6.086063,
      ' 9-25-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      20.137482,
      '10-14-1974',
      42,
      13.760683,
      37,
      ' 0-18-1979',
      NULL,
      99.153131,
      '10-16-1982',
      3.913032,
      40.123048,
      8,
      2.560857,
      ' 3-11-1985',
      NULL,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


