set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8512515';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      '1',
      '2',
      '1',
      '1',
      NULL,
      '0',
      '4',
      '1',
      '2',
      '2',
      '1',
      NULL,
      '0',
      '2',
      '1',
      '2',
      '2',
      '2',
      '1',
      '1',
      '3',
      NULL,
      NULL,
      '3',
      '',
      '3',
      NULL,
      '1',
      '4',
      '1',
      NULL,
      '',
      '2',
      '2',
      '4',
      '3',
      '2',
      '4',
      '4',
      '0',
      '1',
      '3',
      '3',
      '443',
      NULL,
      13,
      18.656741,
      '0430330',
      3,
      1,
      NULL,
      NULL,
      NULL,
      4,
      ' 1-28-1990',
      ' 4-15-2003',
      67,
      NULL,
      33,
      NULL,
      11,
      9,
      48,
      11,
      NULL,
      8,
      31,
      7.358491,
      6,
      10,
      NULL,
      12.375173,
      33,
      9.289759,
      18.884388,
      15,
      17,
      3,
      56.337688,
      20.498132,
      1.789966,
      NULL,
      98.726004,
      NULL,
      148,
      94.477683,
      68.209750,
      ' 3-26-1982',
      36.981570,
      23,
      NULL,
      34.099078,
      NULL,
      204,
      ' 0-27-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      14,
      10.305323,
      6,
      NULL,
      0,
      NULL,
      207.053740,
      0,
      0,
      61,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 7-1980',
      84.829745,
      41.942423,
      NULL,
      87.367442,
      0,
      35.462702,
      86.496969,
      NULL,
      53,
      NULL,
      NULL,
      2.520895,
      NULL,
      33,
      NULL,
      4,
      24.711971,
      79,
      172.041913,
      10,
      ' 4-12-2001',
      25.252252,
      9.023399,
      ' 5-23-1983',
      NULL,
      9.466230,
      5,
      22,
      6,
      12,
      0,
      20,
      NULL,
      113,
      0,
      0,
      14,
      5.970070,
      0.936921,
      0,
      1.618864,
      0,
      ' 9- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      0,
      ' 4-24-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      '10-22-1979',
      11,
      '10-10-1976',
      5,
      NULL,
      ' 4- 9-1987',
      126.715815,
      88,
      ' 6-19-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      31,
      '10-18-2002',
      14,
      NULL,
      38.217634,
      '11- 5-1996',
      1.142008,
      6.627194,
      ' 5- 8-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


