set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8512515';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '3',
      NULL,
      '2',
      NULL,
      '2',
      '0',
      NULL,
      '0',
      '1',
      '1',
      '0',
      NULL,
      NULL,
      '3',
      '4',
      '3',
      '1',
      '0',
      NULL,
      '3',
      '0',
      '3',
      '',
      '2',
      NULL,
      '0',
      '0',
      '2',
      '4',
      '4',
      '',
      '',
      '1',
      '1',
      '0',
      '4',
      '4',
      '4',
      '2',
      '0',
      NULL,
      '1',
      '2',
      '310',
      NULL,
      35.829968,
      74.140084,
      '0333303',
      2,
      81,
      1,
      0,
      '313420',
      3.810703,
      NULL,
      ' 1-15-2000',
      NULL,
      56.147322,
      NULL,
      NULL,
      26.195329,
      12.757590,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.137426,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      39.388022,
      8,
      NULL,
      NULL,
      0.242721,
      8,
      2.501977,
      109,
      142.768121,
      21.737879,
      NULL,
      123,
      140.404912,
      ' 5-11-1990',
      6.326641,
      4.280999,
      NULL,
      28,
      8.525801,
      161,
      ' 0-25-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59.419881,
      17,
      7.866165,
      2.963768,
      5,
      1,
      ' 2- 1-1986',
      NULL,
      1,
      138,
      0,
      1,
      148.130812,
      0.641077,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      ' 6-18-1987',
      77.741165,
      NULL,
      47,
      28,
      38.848903,
      NULL,
      74,
      47,
      NULL,
      70,
      83,
      80,
      ' 5-17-1998',
      NULL,
      18,
      4.285930,
      NULL,
      NULL,
      136.398659,
      NULL,
      ' 9- 9-1981',
      39.288541,
      30.149515,
      ' 5-13-1978',
      NULL,
      NULL,
      31,
      19.321809,
      9.358668,
      4.080256,
      1,
      NULL,
      1.861246,
      16,
      NULL,
      1,
      25.522122,
      31,
      1.307338,
      NULL,
      NULL,
      1.365259,
      ' 0- 6-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.903082,
      '10- 4-1980',
      33.318080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      18.305328,
      ' 7- 9-1980',
      33,
      43,
      23.801763,
      ' 9-23-2002',
      1,
      15.716112,
      ' 7-22-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


