set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2304',
      '43120432',
      '31441201',
      '04030322',
      '34033104',
      NULL,
      '33130134',
      '44420433',
      '04424004',
      NULL,
      '12402322',
      '04303221',
      '34442344',
      '33322113',
      NULL,
      '12301420',
      '41030134',
      '40303221',
      '24424013',
      '14211130',
      '14231034',
      '24343022',
      '34244142',
      NULL,
      NULL,
      '02431342',
      '43012312',
      '23403111',
      '13333032',
      '33123321',
      '12200403',
      '01431402',
      '22234232',
      '03210244',
      '00432103',
      '12413431',
      NULL,
      '32223203',
      NULL,
      '33300411',
      '31311120',
      '30222324',
      '30000444',
      '40214214',
      '02043101',
      '',
      '',
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      '101342',
      1.391312,
      NULL,
      NULL,
      48.972586,
      NULL,
      NULL,
      7.343486,
      14.193250,
      8.057750,
      40.965888,
      17,
      8,
      1,
      30,
      3.482465,
      27.462659,
      NULL,
      10.810332,
      0.291257,
      10,
      11,
      60,
      11,
      25.392338,
      4,
      4,
      6.442847,
      NULL,
      61,
      33,
      NULL,
      155.184252,
      NULL,
      69.154705,
      ' 2-13-1999',
      NULL,
      26.910033,
      0.211064,
      NULL,
      69,
      155.442384,
      ' 9-11-2000',
      0,
      0,
      12.208131,
      1.760009,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668182,
      0.356215,
      0,
      1.601057,
      NULL,
      1.356604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-27-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 9-1982',
      19,
      NULL,
      17,
      11,
      98,
      31.982141,
      78,
      80.301533,
      6,
      90,
      31,
      63,
      ' 9- 0-1992',
      5.928919,
      1.837332,
      9.755624,
      45,
      48.757344,
      27,
      0,
      ' 0-10-1996',
      19,
      1,
      ' 8- 8-1997',
      8,
      5.363188,
      6.840736,
      11.509905,
      5.713702,
      1.795595,
      NULL,
      2,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-19-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      9.589738,
      16,
      ' 3-14-1976',
      1,
      206.628564,
      ' 1- 6-1982',
      4.210184,
      31.900309,
      15,
      7,
      ' 9-10-1992',
      59,
      1.546605,
      26,
      '10-11-1979',
      NULL,
      NULL,
      NULL,
      44.223904,
      1.238007,
      0,
      69.580725,
      44,
      112,
      92.384631,
      50,
      3.288986,
      26,
      NULL,
      0,
      NULL,
      1.882145,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.993353,
      122,
      2.078310,
      4.399982,
      NULL,
      43,
      2,
      0,
      0.685679,
      58.209060,
      0.566207,
      NULL,
      0.826583,
      3.027766,
      0,
      0,
      43,
      70,
      18.867904,
      NULL,
      23,
      69,
      0.175151,
      0.970866,
      NULL,
      1,
      0,
      4,
      11,
      1,
      68,
      NULL,
      0.087075,
      NULL,
      0.743941,
      15,
      15,
      1,
      16.776414,
      50,
      NULL,
      27,
      NULL,
      6,
      2,
      4.926933,
      NULL,
      0.199781,
      0,
      0.269911,
      NULL,
      NULL,
      ' 0-17-1999',
      ' 9- 0-1987',
      NULL,
      NULL,
      '11- 4-1990',
      NULL,
      ' 7-23-2002',
      NULL);
commit;
end;
/


