set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1332',
      '23344032',
      NULL,
      '21102033',
      '31401242',
      '32342140',
      '12204420',
      '01044214',
      '10200121',
      '33113013',
      '33220014',
      '40120444',
      '10242303',
      NULL,
      '40430223',
      '31132034',
      NULL,
      '41313133',
      '23313130',
      '13112030',
      '33440412',
      '14302124',
      '43400003',
      NULL,
      '32224440',
      '42204220',
      '14110240',
      '03211001',
      '44020111',
      '11423213',
      '30240211',
      '00341213',
      NULL,
      '30041024',
      NULL,
      '00411123',
      '30442244',
      NULL,
      '44104103',
      '44014433',
      NULL,
      '23230100',
      '31111000',
      '04303233',
      '32323413',
      '',
      '',
      NULL,
      NULL,
      '4112412',
      0.568880,
      7,
      2,
      NULL,
      '003100',
      1,
      NULL,
      ' 2-11-1997',
      42,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      10,
      9.598312,
      NULL,
      41.631048,
      137,
      ' 9-14-1974',
      0,
      1.883989,
      5.078654,
      1.664525,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469838,
      NULL,
      1.101746,
      0.498375,
      0.485113,
      1.892335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-22-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-19-1977',
      19.334206,
      24.456027,
      106.223033,
      NULL,
      62.757181,
      52.545450,
      36.089566,
      13,
      56.787729,
      73,
      61,
      NULL,
      '11- 3-1993',
      3.688527,
      NULL,
      8.654317,
      17.491770,
      38.887337,
      NULL,
      NULL,
      ' 5-26-1976',
      14,
      28.761266,
      ' 2- 6-1974',
      5.334333,
      NULL,
      NULL,
      NULL,
      NULL,
      7.807806,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      2.497814,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.354562,
      7.267712,
      ' 7-24-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      1,
      0.221133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303123,
      1.633538,
      NULL,
      3.318691,
      0,
      NULL,
      1,
      5,
      110.046756,
      10,
      1,
      218.161720,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.035636,
      1.443366,
      0,
      1,
      6.959859,
      NULL,
      30.409981,
      1,
      66,
      NULL,
      NULL,
      29,
      NULL,
      7,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      2.811870,
      NULL,
      NULL,
      NULL,
      2,
      2.045835,
      1.827220,
      81,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1977',
      ' 6- 2-1991',
      NULL,
      ' 8- 5-1994',
      NULL);
commit;
end;
/


