set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3141',
      '42240024',
      '12123134',
      '32324121',
      '14411301',
      '12101104',
      '24300114',
      '30444334',
      '42022312',
      NULL,
      '02221142',
      NULL,
      NULL,
      NULL,
      '44420033',
      NULL,
      '02301424',
      NULL,
      '04243214',
      '01220133',
      '04301300',
      '04224100',
      '23300440',
      NULL,
      '00301113',
      NULL,
      '03432144',
      '14002411',
      '41222423',
      NULL,
      '20232104',
      '32234101',
      '40132004',
      '01340020',
      '41044331',
      '40231441',
      '11444131',
      NULL,
      NULL,
      '11034430',
      '30321421',
      '22333422',
      '33021043',
      '24132023',
      '20334212',
      '',
      '',
      NULL,
      NULL,
      '1422420',
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.402559,
      ' 7- 7-2001',
      ' 6-18-1978',
      2.131789,
      NULL,
      NULL,
      1.759031,
      15,
      17.197535,
      NULL,
      8,
      18.619204,
      9,
      44,
      0,
      4.917670,
      2,
      11,
      8.789851,
      14,
      7,
      47.172193,
      NULL,
      17,
      2.883071,
      80,
      NULL,
      NULL,
      NULL,
      84.263412,
      4.332000,
      149,
      137.181870,
      101,
      ' 0-15-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-12-1986',
      NULL,
      33,
      29.769770,
      118.553058,
      86,
      68,
      41,
      NULL,
      NULL,
      104,
      NULL,
      30,
      NULL,
      10,
      11,
      1,
      69.353360,
      1.462695,
      NULL,
      0.767307,
      '10-23-1976',
      NULL,
      3.413722,
      ' 6- 4-2002',
      2.724795,
      6.652705,
      9,
      10,
      12.958645,
      0,
      NULL,
      NULL,
      NULL,
      57,
      1.828010,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 9-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      ' 0-19-1995',
      2.789927,
      NULL,
      ' 2-23-2003',
      NULL,
      25.017832,
      0,
      NULL,
      NULL,
      NULL,
      0,
      37.216301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.805772,
      83,
      10,
      NULL,
      1.601435,
      NULL,
      0.627718,
      36.477500,
      1,
      0,
      5,
      1,
      1,
      NULL,
      1,
      4,
      9,
      NULL,
      3,
      180,
      17.997245,
      NULL,
      NULL,
      NULL,
      23,
      0,
      0,
      0,
      0.826150,
      1.190261,
      0,
      NULL,
      32.594975,
      13.513896,
      7.689579,
      67.549439,
      62,
      1.239165,
      6,
      55,
      NULL,
      1.856564,
      2,
      39,
      1,
      55.083428,
      1,
      6.485568,
      0.202027,
      1.209667,
      20.518951,
      23,
      0,
      0.263975,
      NULL,
      31.694299,
      11,
      7.971006,
      NULL,
      6.267423,
      1,
      1,
      NULL,
      1.847265,
      0,
      0.423164,
      NULL,
      ' 1-28-1976',
      ' 4- 6-2001',
      ' 7- 4-1984',
      ' 3- 8-1984',
      NULL,
      ' 3-18-1982',
      NULL,
      NULL);
commit;
end;
/


