set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2403',
      '04122322',
      '43030422',
      '40242334',
      '34410142',
      '32132033',
      '13111042',
      '24000041',
      '43134234',
      '34004111',
      '02130412',
      '22304344',
      '20214120',
      '13043013',
      '12124431',
      NULL,
      '32303103',
      '41100322',
      '12034404',
      '23034142',
      NULL,
      '11331301',
      '00411321',
      '24341442',
      '41140220',
      '13242040',
      '00304132',
      '20223101',
      '02040123',
      '14311342',
      '31003431',
      '01020022',
      '10030233',
      '43224031',
      '22403320',
      '11413404',
      '10112140',
      NULL,
      '40334102',
      '33422044',
      '20130020',
      '04232031',
      '43013303',
      '31030142',
      '20041304',
      NULL,
      '20',
      NULL,
      NULL,
      NULL,
      1.757554,
      13,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-22-1995',
      22,
      NULL,
      17.646068,
      5,
      23,
      3,
      NULL,
      0,
      NULL,
      11.697499,
      45.925389,
      1,
      13.049418,
      4.675817,
      23,
      10.053717,
      NULL,
      21,
      67.141627,
      NULL,
      7.875600,
      14.561360,
      36,
      13,
      0.260592,
      NULL,
      142,
      16.411557,
      NULL,
      143,
      109,
      ' 6-15-1978',
      14,
      10.782212,
      NULL,
      23.604157,
      34.954520,
      124.192794,
      ' 6-16-1989',
      1.713958,
      0.488733,
      3,
      0,
      0.596480,
      1,
      4.213732,
      2,
      1.915216,
      0.780487,
      0,
      0.706842,
      NULL,
      3,
      0,
      0,
      0.257442,
      0,
      1.464293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 8-1976',
      22.789634,
      NULL,
      4.839023,
      NULL,
      7,
      9.977506,
      ' 7-25-1975',
      NULL,
      1,
      49.001903,
      1.562142,
      0.321065,
      132,
      1,
      2,
      35.880708,
      3,
      0.629144,
      3,
      ' 4-16-1974',
      58,
      106,
      NULL,
      15.258206,
      6.384209,
      108,
      57,
      NULL,
      NULL,
      94,
      45,
      NULL,
      ' 1-24-2003',
      8,
      7,
      17.389085,
      NULL,
      15.398429,
      NULL,
      0,
      ' 8- 0-1991',
      19,
      3.362645,
      ' 9-16-1998',
      3.008350,
      11,
      13.525805,
      13,
      NULL,
      5,
      1.160311,
      NULL,
      1.355060,
      62.987015,
      0.277792,
      7,
      9.225029,
      0.726307,
      0.432057,
      NULL,
      3,
      1.410472,
      ' 5-18-1998',
      4.500828,
      0,
      2.381994,
      ' 8-29-1978',
      44.533767,
      2,
      ' 0-23-2003',
      NULL,
      NULL,
      NULL,
      53,
      ' 3- 4-1987',
      NULL,
      '11- 3-2001',
      2,
      2.457912,
      ' 4-11-2003',
      76,
      63,
      ' 9-16-1984',
      1.246640,
      0.333087,
      '11-14-1992',
      1.414283,
      1.234064,
      '10-18-1996',
      NULL,
      0,
      1,
      ' 1-23-1986',
      NULL,
      NULL,
      1.917640,
      ' 5-10-1976',
      1,
      19.256995,
      ' 1- 3-1981',
      3,
      NULL,
      4,
      47,
      NULL,
      19.402194,
      NULL,
      98,
      ' 1- 1-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


