set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      '2',
      '3',
      '1',
      '4',
      NULL,
      '1',
      '0',
      '4',
      '1',
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '1',
      '',
      '0',
      '1',
      '4',
      '2',
      '0',
      '',
      NULL,
      '3',
      NULL,
      '0',
      '1',
      '3',
      NULL,
      '0',
      '1',
      NULL,
      '2',
      '1',
      '322',
      '11013000',
      NULL,
      43,
      NULL,
      2,
      197.182797,
      2,
      NULL,
      '030121',
      0.993873,
      '11-13-1986',
      ' 4-20-1987',
      21.264606,
      288,
      32.502219,
      0,
      11.094695,
      NULL,
      NULL,
      10,
      13,
      9.942313,
      NULL,
      13,
      15.185822,
      16,
      18,
      NULL,
      2.814507,
      NULL,
      12.668892,
      10.736686,
      24,
      5,
      NULL,
      7,
      1,
      14.703242,
      170.451620,
      NULL,
      58,
      21,
      68,
      NULL,
      58,
      21.303655,
      29.381016,
      11,
      NULL,
      168,
      '11- 6-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      7,
      2.393237,
      6.294418,
      5.379085,
      7,
      ' 0- 4-1986',
      0,
      1.451181,
      100.290445,
      0.514882,
      0.985948,
      52,
      NULL,
      1.587921,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      87.402842,
      90,
      85.872362,
      90.197013,
      0.497952,
      14.985655,
      8,
      40,
      NULL,
      87.110900,
      75.187243,
      NULL,
      ' 9-11-1994',
      23,
      8.742303,
      18.149372,
      39,
      51.920966,
      79,
      1,
      ' 3-16-2001',
      6,
      NULL,
      NULL,
      7.037912,
      3,
      3,
      16,
      8,
      3,
      NULL,
      0,
      1.294807,
      76.051548,
      0,
      NULL,
      5.226450,
      17.060441,
      4,
      NULL,
      0,
      1.196052,
      ' 6- 7-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      73.697311,
      10.435569,
      ' 9-27-1993',
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      ' 4-15-1982',
      10,
      6.713260,
      '11- 7-1991',
      50,
      119.366471,
      ' 1- 6-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 6-22-1985',
      12.822328,
      5.594262,
      22,
      ' 3-10-1983',
      0,
      93.068089,
      '11-26-1976',
      3,
      55,
      7.994896,
      23.874325,
      ' 9-21-1991',
      26.604707,
      0,
      121.122442,
      ' 4-18-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


