set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3000',
      '34342042',
      '44100404',
      '03333013',
      '02012244',
      '01113332',
      '40124414',
      '04041002',
      NULL,
      '14013232',
      '42214034',
      '01323204',
      '41134401',
      '34432011',
      NULL,
      '01012134',
      '40000320',
      '43402004',
      '44030143',
      '22020222',
      '30311101',
      '30413113',
      '32323320',
      '43130413',
      '01432023',
      '31301303',
      '21411030',
      NULL,
      '24342043',
      '42112443',
      '24432441',
      '32400214',
      '23133222',
      '11424132',
      '21240024',
      '33033441',
      '42423032',
      '43244340',
      '12144442',
      '03304322',
      '10143113',
      '14102430',
      NULL,
      '14233032',
      NULL,
      NULL,
      '02',
      31,
      6.039252,
      '1133310',
      4.203836,
      1,
      3,
      NULL,
      '341312',
      0,
      '10-19-1977',
      '11-17-1986',
      137.756387,
      NULL,
      23.683409,
      0.440473,
      11.279321,
      4,
      27.963902,
      16.332957,
      16.820091,
      4,
      47,
      10,
      38.615448,
      14.179834,
      NULL,
      NULL,
      21.153658,
      8,
      17.787293,
      16,
      18.035773,
      NULL,
      74.511555,
      4.064988,
      0.824501,
      20,
      193.283799,
      NULL,
      213.805296,
      NULL,
      NULL,
      ' 6-17-2003',
      0.924735,
      23.584764,
      26,
      9.230602,
      59.538108,
      NULL,
      ' 1-20-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.326431,
      2.966945,
      1,
      NULL,
      NULL,
      5,
      '10-14-1978',
      1,
      2.676555,
      NULL,
      1.933096,
      0,
      71,
      1.731661,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-21-1996',
      86.935818,
      95.703900,
      30.766718,
      69,
      NULL,
      97,
      111.058459,
      NULL,
      30,
      NULL,
      7,
      26,
      ' 5-11-1991',
      NULL,
      39.943690,
      7,
      13.358519,
      30,
      75,
      2,
      ' 1-19-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.016091,
      7,
      ' 5-11-1977',
      NULL,
      NULL,
      NULL,
      30,
      '11-27-1990',
      6,
      ' 4- 5-1983',
      4.897210,
      0,
      ' 8- 0-1979',
      NULL,
      52.368068,
      '11- 1-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      ' 2-25-1990',
      15,
      38,
      4,
      '10-11-1984',
      0.072823,
      139,
      '10-12-1983',
      9,
      32.902850,
      10.111197,
      NULL,
      ' 8- 9-1990',
      60,
      1,
      229,
      ' 7-16-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


