set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9037217';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2433',
      '43442241',
      '04213401',
      '21010313',
      '01412021',
      '23403021',
      '24304001',
      NULL,
      '21344144',
      '13200233',
      '33033230',
      '14021404',
      '34204301',
      '14001302',
      '20031022',
      '21334431',
      '43010011',
      '40100301',
      '04404033',
      '40020112',
      '33440344',
      '42222200',
      '22441340',
      '12130211',
      '03343443',
      NULL,
      '14020404',
      NULL,
      '11410311',
      NULL,
      '43410332',
      '34010034',
      NULL,
      '44012131',
      '22120020',
      '12301223',
      NULL,
      '21432003',
      NULL,
      '31221141',
      NULL,
      '32122402',
      '22420444',
      '13003101',
      NULL,
      '241',
      NULL,
      NULL,
      NULL,
      '0140101',
      2.518612,
      1,
      NULL,
      NULL,
      '303212',
      NULL,
      ' 2-21-1991',
      '11-21-2000',
      NULL,
      NULL,
      32,
      8,
      34.652391,
      0,
      86,
      9.444726,
      18,
      1,
      26.586318,
      21.371342,
      17.026059,
      9.506951,
      21.628246,
      NULL,
      2,
      14.147701,
      NULL,
      20.574093,
      58,
      NULL,
      60.841446,
      7,
      0.217283,
      3.816713,
      104,
      NULL,
      9,
      89,
      203.276282,
      ' 6-14-1982',
      NULL,
      6.953702,
      8.413673,
      24.889914,
      135,
      6.428175,
      ' 1-22-1988',
      0,
      0.823710,
      NULL,
      1.502191,
      1,
      NULL,
      3,
      1.319198,
      1,
      1,
      1,
      0.121551,
      NULL,
      0.291386,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      22,
      0.093077,
      0,
      4,
      2,
      ' 1-12-1993',
      0,
      1.594266,
      NULL,
      1,
      4.909896,
      132.015359,
      1.402435,
      NULL,
      76.923160,
      NULL,
      NULL,
      NULL,
      ' 4-25-1985',
      NULL,
      87.525188,
      62.837432,
      41,
      NULL,
      NULL,
      87,
      64,
      74.663446,
      8,
      86,
      23.781613,
      ' 0-14-1977',
      15.452607,
      NULL,
      NULL,
      58.784497,
      52,
      33.493319,
      5,
      '10-12-1989',
      16,
      5,
      ' 8-14-1995',
      9.158867,
      3,
      18.874188,
      5.734620,
      NULL,
      0.173885,
      1,
      12.115155,
      1,
      26.961620,
      NULL,
      4,
      11,
      20.695131,
      1,
      4.373976,
      1.127769,
      0,
      ' 3-16-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      212.653667,
      0,
      ' 3- 6-1985',
      NULL,
      NULL,
      NULL,
      8.504463,
      ' 4-19-1983',
      9.670281,
      ' 9-29-1991',
      6,
      NULL,
      NULL,
      60.054390,
      NULL,
      '10-11-2002',
      4,
      2,
      ' 3-29-1976',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      11.012881,
      ' 3- 4-1996',
      32.675692,
      NULL,
      39.707356,
      ' 8-28-1978',
      0,
      16.293907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


