set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2203',
      '41223113',
      '32201031',
      '33040313',
      '23432112',
      '41230022',
      NULL,
      '01432021',
      NULL,
      '34302213',
      '41330411',
      '23121010',
      '31013011',
      NULL,
      '31404230',
      NULL,
      '03043424',
      '12030413',
      '44334123',
      '34324302',
      '20123204',
      '24312434',
      NULL,
      '23341404',
      NULL,
      '10424412',
      NULL,
      '32223242',
      '03344320',
      '14444023',
      '33131243',
      '12323030',
      '03230220',
      '12420131',
      '10331320',
      NULL,
      NULL,
      '02313442',
      NULL,
      '23322143',
      NULL,
      '34230214',
      '32123242',
      '31333300',
      '42112142',
      NULL,
      NULL,
      NULL,
      NULL,
      '0412242',
      NULL,
      1,
      3,
      NULL,
      '433004',
      NULL,
      '11-24-2002',
      ' 0- 7-1977',
      NULL,
      NULL,
      19.284466,
      11.958389,
      10,
      13,
      72,
      16,
      NULL,
      NULL,
      10,
      9,
      8,
      6.525724,
      17.065704,
      6.019594,
      3,
      8,
      26,
      NULL,
      23,
      10.078414,
      NULL,
      NULL,
      NULL,
      10.355290,
      93,
      46,
      75.837170,
      92,
      108,
      ' 7-25-1989',
      15.121913,
      NULL,
      5.144714,
      20.967760,
      116.003906,
      30.075811,
      ' 6-11-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236340,
      0,
      3,
      0.801596,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-18-1981',
      NULL,
      110.701156,
      109,
      54,
      28,
      NULL,
      99,
      34,
      12,
      68.063120,
      6,
      79,
      ' 8-28-2003',
      NULL,
      16,
      8,
      NULL,
      58.228560,
      NULL,
      NULL,
      ' 8-24-1983',
      16.586518,
      8,
      NULL,
      5.320423,
      4,
      7.408137,
      0,
      NULL,
      3,
      NULL,
      13,
      NULL,
      16,
      0,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 0-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48.940659,
      1,
      26.567052,
      ' 0-24-1985',
      0.700146,
      261,
      '10-28-1987',
      3,
      62.379565,
      12.933645,
      NULL,
      ' 0- 0-1982',
      14,
      0.851157,
      192,
      NULL,
      NULL,
      NULL,
      NULL,
      13.538170,
      NULL,
      2.479351,
      41,
      44.876966,
      72.235060,
      117.683601,
      43.893462,
      35,
      118.023225,
      3,
      51,
      0.871287,
      1.977684,
      86,
      1.463706,
      2.510975,
      29,
      NULL,
      1.770114,
      122,
      NULL,
      NULL,
      NULL,
      16.857576,
      17,
      51.473601,
      1,
      NULL,
      NULL,
      0,
      1.535543,
      3.438345,
      1,
      NULL,
      49,
      65,
      53,
      24,
      37,
      60.538121,
      4.679729,
      3.957970,
      5,
      0.017743,
      4.119450,
      0,
      8.252433,
      0.927818,
      14.443789,
      1.741469,
      31.980052,
      1.517485,
      0.512404,
      36,
      NULL,
      0.598465,
      28,
      60,
      NULL,
      18.220742,
      35,
      11.324810,
      7,
      4.558888,
      NULL,
      2.480665,
      0.916144,
      1.060877,
      0,
      49.720007,
      ' 6- 9-2000',
      ' 3- 5-1981',
      NULL,
      NULL,
      ' 5-15-1999',
      NULL,
      ' 4- 2-1980',
      NULL);
commit;
end;
/


